/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore.strategy.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.aws.s3.AWSS3Client;
import org.jclouds.aws.s3.blobstore.strategy.MultipartUploadStrategy;
import org.jclouds.aws.s3.blobstore.strategy.internal.MultipartUploadSlicingAlgorithm;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.logging.Logger;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.domain.ObjectMetadataBuilder;
import org.jclouds.s3.options.PutObjectOptions;

public class SequentialMultipartUploadStrategy
implements MultipartUploadStrategy {
    @Resource
    @Named(value="jclouds.blobstore")
    private Logger logger = Logger.NULL;
    private final AWSS3Client client;
    private final BlobToObject blobToObject;
    private final MultipartUploadSlicingAlgorithm algorithm;
    private final PayloadSlicer slicer;

    @Inject
    public SequentialMultipartUploadStrategy(AWSS3Client client, BlobToObject blobToObject, MultipartUploadSlicingAlgorithm algorithm, PayloadSlicer slicer) {
        this.client = (AWSS3Client)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.blobToObject = (BlobToObject)Preconditions.checkNotNull((Object)blobToObject, (Object)"blobToObject");
        this.algorithm = (MultipartUploadSlicingAlgorithm)Preconditions.checkNotNull((Object)algorithm, (Object)"algorithm");
        this.slicer = (PayloadSlicer)Preconditions.checkNotNull((Object)slicer, (Object)"slicer");
    }

    @Override
    public String execute(String container, Blob blob) {
        String key = blob.getMetadata().getName();
        MutableContentMetadata metadata = blob.getMetadata().getContentMetadata();
        Payload payload = blob.getPayload();
        Long length = payload.getContentMetadata().getContentLength();
        Preconditions.checkNotNull((Object)length, (Object)"please invoke payload.getContentMetadata().setContentLength(length) prior to multipart upload");
        long chunkSize = this.algorithm.calculateChunkSize(length);
        int partCount = this.algorithm.getParts();
        if (partCount > 0) {
            ObjectMetadataBuilder builder = ObjectMetadataBuilder.create().key(key).contentType(metadata.getContentType()).contentDisposition(metadata.getContentDisposition()).contentEncoding(metadata.getContentEncoding()).contentLanguage(metadata.getContentLanguage()).userMetadata(blob.getMetadata().getUserMetadata());
            String uploadId = this.client.initiateMultipartUpload(container, builder.build(), new PutObjectOptions[0]);
            try {
                TreeMap etags = Maps.newTreeMap();
                for (Payload part : this.slicer.slice(payload, chunkSize)) {
                    int partNum = this.algorithm.getNextPart();
                    this.prepareUploadPart(container, key, uploadId, partNum, part, this.algorithm.getNextChunkOffset(), etags);
                }
                return this.client.completeMultipartUpload(container, key, uploadId, etags);
            }
            catch (RuntimeException ex) {
                this.client.abortMultipartUpload(container, key, uploadId);
                throw ex;
            }
        }
        return this.client.putObject(container, this.blobToObject.apply(blob), new PutObjectOptions[0]);
    }

    private void prepareUploadPart(String container, String key, String uploadId, int part, Payload chunkedPart, long offset, SortedMap<Integer, String> etags) {
        String eTag = null;
        try {
            eTag = this.client.uploadPart(container, key, part, uploadId, chunkedPart);
            etags.put(part, eTag);
        }
        catch (KeyNotFoundException e) {
            eTag = this.client.uploadPart(container, key, part, uploadId, chunkedPart);
            etags.put(part, eTag);
        }
    }
}

