/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore.strategy.internal;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Module;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.jclouds.ContextBuilder;
import org.jclouds.aws.s3.blobstore.strategy.internal.SequentialMultipartUploadStrategy;
import org.jclouds.blobstore.domain.internal.BlobBuilderImpl;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.http.HttpResponseException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class SequentialMultipartUploadStrategyMockTest {
    private static final Set<Module> modules = ImmutableSet.of((Object)new ExecutorServiceModule(MoreExecutors.sameThreadExecutor(), MoreExecutors.sameThreadExecutor()));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMPUDoesMultipart() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setResponseCode(200).setBody("<UploadId>upload-id</UploadId>"));
        server.enqueue(new MockResponse().setResponseCode(200).addHeader("ETag", (Object)"a00"));
        server.enqueue(new MockResponse().setResponseCode(200).addHeader("ETag", (Object)"b00"));
        server.enqueue(new MockResponse().setResponseCode(200).setBody("<ETag>fff</ETag>"));
        server.play();
        byte[] bytes = "0123456789abcdef".getBytes(Charsets.US_ASCII);
        int partSize = bytes.length / 2;
        SequentialMultipartUploadStrategy api = SequentialMultipartUploadStrategyMockTest.mockSequentialMultipartUploadStrategy(server.getUrl("/").toString(), partSize);
        try {
            Assert.assertEquals((String)api.execute("container", new BlobBuilderImpl().name("foo").payload(bytes).contentDisposition("inline; filename=foo.mp4").contentType(MediaType.MP4_VIDEO.toString()).build()), (String)"fff");
        }
        finally {
            RecordedRequest initiate = server.takeRequest();
            Assert.assertEquals((String)initiate.getRequestLine(), (String)"POST /container/foo?uploads HTTP/1.1");
            Assert.assertEquals((String)initiate.getHeader("Content-Length"), (String)"0");
            Assert.assertEquals((String)initiate.getHeader("Content-Type"), (String)MediaType.MP4_VIDEO.toString());
            Assert.assertEquals((String)initiate.getHeader("Content-Disposition"), (String)"inline; filename=foo.mp4");
            RecordedRequest part1 = server.takeRequest();
            Assert.assertEquals((String)part1.getRequestLine(), (String)"PUT /container/foo?partNumber=1&uploadId=upload-id HTTP/1.1");
            Assert.assertEquals((String)part1.getHeader("Content-Length"), (String)String.valueOf(partSize));
            Assert.assertEquals((String)new String(part1.getBody()), (String)"01234567");
            RecordedRequest part2 = server.takeRequest();
            Assert.assertEquals((String)part2.getRequestLine(), (String)"PUT /container/foo?partNumber=2&uploadId=upload-id HTTP/1.1");
            Assert.assertEquals((String)part2.getHeader("Content-Length"), (String)String.valueOf(partSize));
            Assert.assertEquals((String)new String(part2.getBody()), (String)"89abcdef");
            RecordedRequest manifest = server.takeRequest();
            Assert.assertEquals((String)manifest.getRequestLine(), (String)"POST /container/foo?uploadId=upload-id HTTP/1.1");
            Assert.assertEquals((String)manifest.getHeader("Content-Length"), (String)"161");
            Assert.assertEquals((String)new String(manifest.getBody()), (String)"<CompleteMultipartUpload><Part><PartNumber>1</PartNumber><ETag>a00</ETag></Part><Part><PartNumber>2</PartNumber><ETag>b00</ETag></Part></CompleteMultipartUpload>");
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={HttpResponseException.class})
    public void testMPUAbortsOnProblem() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setResponseCode(200).setBody("<UploadId>upload-id</UploadId>"));
        server.enqueue(new MockResponse().setResponseCode(400));
        server.enqueue(new MockResponse().setResponseCode(200));
        server.play();
        byte[] bytes = "0123456789abcdef".getBytes(Charsets.US_ASCII);
        int partSize = bytes.length / 2;
        SequentialMultipartUploadStrategy api = SequentialMultipartUploadStrategyMockTest.mockSequentialMultipartUploadStrategy(server.getUrl("/").toString(), partSize);
        try {
            Assert.assertEquals((String)api.execute("container", new BlobBuilderImpl().name("foo").payload(bytes).build()), (String)"fff");
        }
        finally {
            RecordedRequest initiate = server.takeRequest();
            Assert.assertEquals((String)initiate.getRequestLine(), (String)"POST /container/foo?uploads HTTP/1.1");
            Assert.assertEquals((String)initiate.getHeader("Content-Length"), (String)"0");
            RecordedRequest part1 = server.takeRequest();
            Assert.assertEquals((String)part1.getRequestLine(), (String)"PUT /container/foo?partNumber=1&uploadId=upload-id HTTP/1.1");
            Assert.assertEquals((String)part1.getHeader("Content-Length"), (String)String.valueOf(partSize));
            Assert.assertEquals((String)new String(part1.getBody()), (String)"01234567");
            RecordedRequest abort = server.takeRequest();
            Assert.assertEquals((String)abort.getRequestLine(), (String)"DELETE /container/foo?uploadId=upload-id HTTP/1.1");
            server.shutdown();
        }
    }

    static SequentialMultipartUploadStrategy mockSequentialMultipartUploadStrategy(String uri, int partSize) {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.s3.virtual-host-buckets", "false");
        overrides.setProperty("jclouds.so-timeout", "0");
        overrides.setProperty("jclouds.max-retries", "1");
        overrides.setProperty("jclouds.mpu.parts.size", String.valueOf(partSize));
        return (SequentialMultipartUploadStrategy)ContextBuilder.newBuilder((String)"aws-s3").credentials("accessKey", "secretKey").endpoint(uri).overrides(overrides).modules(modules).buildInjector().getInstance(SequentialMultipartUploadStrategy.class);
    }
}

