/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3;

import com.google.common.base.Charsets;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hashing;
import com.google.inject.Injector;
import java.util.Map;
import java.util.Set;
import org.jclouds.aws.s3.AWSS3Client;
import org.jclouds.aws.s3.blobstore.options.AWSS3PutObjectOptions;
import org.jclouds.aws.s3.domain.DeleteResult;
import org.jclouds.aws.s3.internal.BaseAWSS3ClientExpectTest;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.options.PutObjectOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class AWSS3ClientExpectTest
extends BaseAWSS3ClientExpectTest {
    HttpRequest bucketLocationRequest = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://test.s3.amazonaws.com/?location").addHeader("Host", new String[]{"test.s3.amazonaws.com"})).addHeader("Date", new String[]{"2009-11-08T15:54:08.897Z"})).addHeader("Authorization", new String[]{"AWS identity:D1rymKrEdvzvhmZXeg+Z0R+tiug="})).build();
    HttpResponse bucketLocationResponse = ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(AWSS3ClientExpectTest.payloadFromStringWithContentType((String)"<LocationConstraint xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">eu-west-1</LocationConstraint>", (String)"application/xml"))).addHeader("x-amz-id-2", new String[]{"BtioT9wIK04YkE2DPgWUrQFiAbjwJVP8cLyfOkJ1FHMbn2hVjBZvkMMuXPDHfGVw"})).addHeader("x-amz-request-id", new String[]{"51BF4F45D49B1B34"})).addHeader("Date", new String[]{"2009-11-08T15:54:08.897Z"})).addHeader("Server", new String[]{"AmazonS3"})).build();

    @Test
    public void testPutWithReducedRedundancy() {
        Injector injector = this.createInjector(Functions.forMap((Map)ImmutableMap.of()), this.createModule(), this.setupProperties());
        Blob blob = ((BlobBuilder)injector.getInstance(BlobBuilder.class)).name("test").payload("content").build();
        BlobToObject blobToObject = (BlobToObject)injector.getInstance(BlobToObject.class);
        AWSS3Client client = (AWSS3Client)this.requestsSendResponses(this.bucketLocationRequest, this.bucketLocationResponse, ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://test.s3-eu-west-1.amazonaws.com/test").addHeader("Expect", new String[]{"100-continue"})).addHeader("x-amz-storage-class", new String[]{"REDUCED_REDUNDANCY"})).addHeader("Host", new String[]{"test.s3-eu-west-1.amazonaws.com"})).addHeader("Date", new String[]{"2009-11-08T15:54:08.897Z"})).addHeader("Authorization", new String[]{"AWS identity:1mJrW85/mqZpYTFIK5Ebtt2MM6E="})).payload("content")).build(), ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).addHeader("x-amz-id-2", new String[]{"w0rL+9fALQiCOToesVQefs8WalIgn+ZhMD7hHMKYud/xv7MyKkAWQOtFNEfK97Ri"})).addHeader("x-amz-request-id", new String[]{"7A84C3CD4437A4C0"})).addHeader("Date", new String[]{"2009-11-08T15:54:08.897Z"})).addHeader("ETag", new String[]{"437b930db84b8079c2dd804a71936b5f"})).addHeader("Server", new String[]{"AmazonS3"})).build());
        client.putObject("test", blobToObject.apply(blob), new PutObjectOptions[]{AWSS3PutObjectOptions.Builder.storageClass((ObjectMetadata.StorageClass)ObjectMetadata.StorageClass.REDUCED_REDUNDANCY)});
    }

    @Test
    public void testDeleteMultipleObjects() {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Delete><Object><Key>key1</Key></Object><Object><Key>key2</Key></Object></Delete>";
        StringPayload requestPayload = Payloads.newStringPayload((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Delete><Object><Key>key1</Key></Object><Object><Key>key2</Key></Object></Delete>");
        requestPayload.getContentMetadata().setContentType("text/xml");
        requestPayload.getContentMetadata().setContentMD5(Hashing.md5().hashString((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Delete><Object><Key>key1</Key></Object><Object><Key>key2</Key></Object></Delete>", Charsets.UTF_8));
        String response = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DeleteResult xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">\n  <Deleted>\n    <Key>key1</Key>\n  </Deleted>\n  <Deleted>\n    <Key>key1.1</Key>\n  </Deleted>\n  <Error>\n    <Key>key2</Key>\n    <Code>AccessDenied</Code>\n    <Message>Access Denied</Message>\n  </Error>\n</DeleteResult>";
        StringPayload responsePayload = Payloads.newStringPayload((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DeleteResult xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">\n  <Deleted>\n    <Key>key1</Key>\n  </Deleted>\n  <Deleted>\n    <Key>key1.1</Key>\n  </Deleted>\n  <Error>\n    <Key>key2</Key>\n    <Code>AccessDenied</Code>\n    <Message>Access Denied</Message>\n  </Error>\n</DeleteResult>");
        responsePayload.getContentMetadata().setContentType("text/xml");
        AWSS3Client client = (AWSS3Client)this.requestsSendResponses(this.bucketLocationRequest, this.bucketLocationResponse, ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://test.s3-eu-west-1.amazonaws.com/?delete").addHeader("Host", new String[]{"test.s3-eu-west-1.amazonaws.com"})).addHeader("Date", new String[]{"2009-11-08T15:54:08.897Z"})).addHeader("Authorization", new String[]{"AWS identity:/k3HQNVVyAQMsr9qhx6hajocVu4="})).payload((Payload)requestPayload)).build(), ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).addHeader("x-amz-request-id", new String[]{"7A84C3CD4437A4C0"})).addHeader("Date", new String[]{"2009-11-08T15:54:08.897Z"})).addHeader("ETag", new String[]{"437b930db84b8079c2dd804a71936b5f"})).addHeader("Server", new String[]{"AmazonS3"})).payload((Payload)responsePayload)).build());
        DeleteResult result = client.deleteObjects("test", (Iterable)ImmutableSet.of((Object)"key1", (Object)"key2"));
        Assert.assertNotNull((Object)result, (String)"result is null");
        Assert.assertEquals((Set)result.getDeleted(), (Set)ImmutableSet.of((Object)"key1", (Object)"key1.1"));
        Assert.assertEquals((int)result.getErrors().size(), (int)1);
        Assert.assertEquals(result.getErrors().get("key2"), (Object)new DeleteResult.Error("AccessDenied", "Access Denied"));
    }
}

