/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.reflect.Invokable;
import com.google.inject.Module;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.aws.s3.AWSS3AsyncClient;
import org.jclouds.aws.s3.AWSS3ProviderMetadata;
import org.jclouds.aws.s3.config.AWSS3RestClientModule;
import org.jclouds.aws.s3.filters.AWSRequestAuthorizeSignature;
import org.jclouds.aws.s3.functions.ETagFromHttpResponseViaRegex;
import org.jclouds.aws.s3.functions.UploadIdFromHttpResponseViaRegex;
import org.jclouds.blobstore.binders.BindBlobToMultipartFormTest;
import org.jclouds.date.TimeStamp;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.functions.ParseETagHeader;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.http.functions.ReturnTrueIf2xx;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.location.Region;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.S3AsyncClientTest;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.ObjectMetadataBuilder;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.fallbacks.FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists;
import org.jclouds.s3.options.CopyObjectOptions;
import org.jclouds.s3.options.PutBucketOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.jclouds.s3.xml.LocationConstraintHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AWSS3AsyncClientTest")
public class AWSS3AsyncClientTest
extends S3AsyncClientTest<AWSS3AsyncClient> {
    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), AWSRequestAuthorizeSignature.class);
    }

    public void testCopyObjectInvalidName() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"copyObject", (Class[])new Class[]{String.class, String.class, String.class, String.class, CopyObjectOptions[].class});
        this.processor.createRequest(method, (List)ImmutableList.of((Object)"sourceBucket", (Object)"sourceObject", (Object)"destinationbucket", (Object)"destinationObject"));
    }

    public void testGetBucketLocationEUIsStillDefault() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AWSS3AsyncClient.class, (String)"getBucketLocation", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket-eu-west-1"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://bucket-eu-west-1.s3.amazonaws.com/?location HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket-eu-west-1.s3.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, LocationConstraintHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testPutObject() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AWSS3AsyncClient.class, (String)"putObject", (Class[])new Class[]{String.class, S3Object.class, PutObjectOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)this.blobToS3Object.apply(BindBlobToMultipartFormTest.TEST_BLOB)));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://bucket." + this.url + "/hello HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Expect: 100-continue\nHost: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, "hello", "text/plain", false);
        this.assertResponseParserClassEquals(method, request, ParseETagHeader.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetBucketLocation() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AWSS3AsyncClient.class, (String)"getBucketLocation", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://bucket.s3.amazonaws.com/?location HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket.s3.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        request = (GeneratedHttpRequest)this.filter.filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "GET https://bucket.s3.amazonaws.com/?location HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Authorization: AWS identity:2fFTeYJTDwiJmaAkKj732RjNbOg=\nDate: 2009-11-08T15:54:08.897Z\nHost: bucket.s3.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, LocationConstraintHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testPutBucketDefault() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AWSS3AsyncClient.class, (String)"putBucketInRegion", (Class[])new Class[]{String.class, String.class, PutBucketOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "bucket"}));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://bucket.s3.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket.s3.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testInitiateMultipartUpload() throws SecurityException, NegativeArraySizeException, NoSuchMethodException {
        Invokable method = Reflection2.method(AWSS3AsyncClient.class, (String)"initiateMultipartUpload", (Class[])new Class[]{String.class, ObjectMetadata.class, PutObjectOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)ObjectMetadataBuilder.create().key("foo").contentMD5(new byte[]{1, 2, 3, 4}).build()));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://bucket." + this.url + "/foo?uploads HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Content-MD5: AQIDBA==\nContent-Type: binary/octet-stream\nHost: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://bucket." + this.url + "/foo?uploads HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Authorization: AWS identity:Sp1FX4svL9P2u2bFJwroaYpSANo=\nContent-MD5: AQIDBA==\nContent-Type: binary/octet-stream\nDate: 2009-11-08T15:54:08.897Z\nHost: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UploadIdFromHttpResponseViaRegex.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testAbortMultipartUpload() throws SecurityException, NegativeArraySizeException, NoSuchMethodException {
        Invokable method = Reflection2.method(AWSS3AsyncClient.class, (String)"abortMultipartUpload", (Class[])new Class[]{String.class, String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)"foo", (Object)"asdsadasdas", (Object)1, (Object)Payloads.newStringPayload((String)"")));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://bucket." + this.url + "/foo?uploadId=asdsadasdas HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, "", "application/unknown", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testUploadPart() throws SecurityException, NegativeArraySizeException, NoSuchMethodException {
        Invokable method = Reflection2.method(AWSS3AsyncClient.class, (String)"uploadPart", (Class[])new Class[]{String.class, String.class, Integer.TYPE, String.class, Payload.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)"foo", (Object)1, (Object)"asdsadasdas", (Object)Payloads.newStringPayload((String)"")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://bucket." + this.url + "/foo?partNumber=1&uploadId=asdsadasdas HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, "", "application/unknown", false);
        this.assertResponseParserClassEquals(method, request, ParseETagHeader.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCompleteMultipartUpload() throws SecurityException, NegativeArraySizeException, NoSuchMethodException {
        Invokable method = Reflection2.method(AWSS3AsyncClient.class, (String)"completeMultipartUpload", (Class[])new Class[]{String.class, String.class, String.class, Map.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)"foo", (Object)"asdsadasdas", (Object)ImmutableMap.of((Object)1, (Object)"\"a54357aff0632cce46d942af68356b38\"")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://bucket." + this.url + "/foo?uploadId=asdsadasdas HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, "<CompleteMultipartUpload><Part><PartNumber>1</PartNumber><ETag>\"a54357aff0632cce46d942af68356b38\"</ETag></Part></CompleteMultipartUpload>", "text/xml", false);
        this.assertResponseParserClassEquals(method, request, ETagFromHttpResponseViaRegex.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testPutBucketEu() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AWSS3AsyncClient.class, (String)"putBucketInRegion", (Class[])new Class[]{String.class, String.class, PutBucketOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"EU", (Object)"bucket"));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://bucket.s3.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket.s3.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "<CreateBucketConfiguration><LocationConstraint>EU</LocationConstraint></CreateBucketConfiguration>", "text/xml", false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists.class);
        this.checkFilters((HttpRequest)request);
    }

    protected Module createModule() {
        return new TestAWSS3RestClientModule();
    }

    public AWSS3ProviderMetadata createProviderMetadata() {
        return new AWSS3ProviderMetadata();
    }

    @ConfiguresRestClient
    private static final class TestAWSS3RestClientModule
    extends AWSS3RestClientModule {
        private TestAWSS3RestClientModule() {
        }

        protected CacheLoader<String, Optional<String>> bucketToRegion(@Region Supplier<Set<String>> regionSupplier, S3Client client) {
            return CacheLoader.from((Function)Functions.forMap((Map)ImmutableMap.builder().put((Object)"bucket", (Object)Optional.absent()).put((Object)"destinationbucket", (Object)Optional.absent()).put((Object)"bucket-us-standard", (Object)Optional.of((Object)"us-standard")).put((Object)"bucket-us-west-1", (Object)Optional.of((Object)"us-west-1")).put((Object)"bucket-us-west-2", (Object)Optional.of((Object)"us-west-2")).put((Object)"bucket-eu-west-1", (Object)Optional.of((Object)"eu-west-1")).put((Object)"bucket-sa-east-1", (Object)Optional.of((Object)"sa-east-1")).put((Object)"bucket-ap-southeast-1", (Object)Optional.of((Object)"ap-southeast-1")).put((Object)"bucket-ap-northeast-1", (Object)Optional.of((Object)"ap-northeast-1")).build()));
        }

        protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
            return "2009-11-08T15:54:08.897Z";
        }
    }
}

