/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.providers;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import org.jclouds.Context;
import org.jclouds.View;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.ApiPredicates;
import org.jclouds.providers.ProviderMetadata;

public class ProviderPredicates {
    public static Predicate<ProviderMetadata> all() {
        return Predicates.alwaysTrue();
    }

    public static Predicate<ProviderMetadata> id(final String id) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)id), (Object)"id must be defined");
        return new Predicate<ProviderMetadata>(){

            public boolean apply(ProviderMetadata providerMetadata) {
                return providerMetadata.getId().equals(id);
            }

            public String toString() {
                return "id(" + id + ")";
            }
        };
    }

    public static Predicate<ProviderMetadata> boundedByIso3166Code(final String iso3166Code) {
        Preconditions.checkNotNull((Object)iso3166Code, (Object)"iso3166Code must not be null");
        return new Predicate<ProviderMetadata>(){

            public boolean apply(ProviderMetadata providerMetadata) {
                return ProviderPredicates.providerContainsIso3166Code(providerMetadata, iso3166Code);
            }

            public String toString() {
                return "boundedByIso3166Code(" + iso3166Code + ")";
            }
        };
    }

    public static Predicate<ProviderMetadata> intersectingIso3166Code(final ProviderMetadata refProviderMetadata) {
        Preconditions.checkNotNull((Object)refProviderMetadata, (Object)"refProviderMetadata must not be null");
        return new Predicate<ProviderMetadata>(){

            public boolean apply(ProviderMetadata providerMetadata) {
                for (String refIso3166Code : refProviderMetadata.getIso3166Codes()) {
                    if (!ProviderPredicates.providerContainsIso3166Code(providerMetadata, refIso3166Code) || refProviderMetadata.equals(providerMetadata)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "intersectingIso3166Code(" + refProviderMetadata + ")";
            }
        };
    }

    private static boolean providerContainsIso3166Code(ProviderMetadata providerMetadata, String iso3166Code) {
        for (String availCode : providerMetadata.getIso3166Codes()) {
            if (!(iso3166Code.indexOf(45) == -1 ? availCode.startsWith(iso3166Code + "-") : availCode.equals(iso3166Code))) continue;
            return true;
        }
        return false;
    }

    public static Predicate<ProviderMetadata> apiMetadataAssignableFrom(final TypeToken<? extends ApiMetadata> apiClass) {
        Preconditions.checkNotNull(apiClass, (Object)"api must be defined");
        return new Predicate<ProviderMetadata>(){

            public boolean apply(ProviderMetadata providerMetadata) {
                return apiClass.isAssignableFrom(providerMetadata.getApiMetadata().getClass());
            }

            public String toString() {
                return "apiAssignableFrom(" + apiClass + ")";
            }
        };
    }

    public static Predicate<ProviderMetadata> contextAssignableFrom(TypeToken<? extends Context> type) {
        return new ContextAssignableFrom(type);
    }

    public static Predicate<ProviderMetadata> viewableAs(TypeToken<? extends View> type) {
        return new TransformableTo(type);
    }

    public static class TransformableTo
    implements Predicate<ProviderMetadata> {
        private final TypeToken<? extends View> type;

        public TransformableTo(TypeToken<? extends View> type) {
            Preconditions.checkNotNull(type, (Object)"context must be defined");
            this.type = type;
        }

        public boolean apply(ProviderMetadata providerMetadata) {
            return ApiPredicates.viewableAs(this.type).apply((Object)providerMetadata.getApiMetadata());
        }

        public String toString() {
            return "viewableAs(" + this.type + ")";
        }
    }

    public static class ContextAssignableFrom
    implements Predicate<ProviderMetadata> {
        private final TypeToken<? extends Context> type;

        public ContextAssignableFrom(TypeToken<? extends Context> type) {
            Preconditions.checkNotNull(type, (Object)"context must be defined");
            this.type = type;
        }

        public boolean apply(ProviderMetadata providerMetadata) {
            return ApiPredicates.contextAssignableFrom(this.type).apply((Object)providerMetadata.getApiMetadata());
        }

        public String toString() {
            return "contextAssignableFrom(" + this.type + ")";
        }
    }
}

