/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;

public class DelegatingPayload
implements Payload {
    private final Payload delegate;

    public DelegatingPayload(Payload delegate) {
        this.delegate = (Payload)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.delegate.openStream();
    }

    @Override
    public InputStream getInput() {
        try {
            return this.openStream();
        }
        catch (IOException ioe) {
            throw Throwables.propagate((Throwable)ioe);
        }
    }

    @Override
    public Object getRawContent() {
        return this.delegate.getInput();
    }

    @Override
    public boolean isRepeatable() {
        return this.delegate.isRepeatable();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public Payload getDelegate() {
        return this.delegate;
    }

    @Override
    public void release() {
        this.delegate.release();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public MutableContentMetadata getContentMetadata() {
        return this.delegate.getContentMetadata();
    }

    @Override
    public void setContentMetadata(MutableContentMetadata in) {
        this.delegate.setContentMetadata(in);
    }
}

