/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.annotationparsing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.Closeable;
import java.io.IOException;
import org.easymock.EasyMock;
import org.jclouds.ContextBuilder;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ClosableApiTest")
public class ClosableApiTest {
    ProviderMetadata provider = AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(DelegatingApi.class, DelegatingAsyncApi.class, (String)"http://mock");

    public void testApiClosesExecutorServiceOnClose() throws IOException {
        ListeningExecutorService executor = (ListeningExecutorService)EasyMock.createMock(ListeningExecutorService.class);
        EasyMock.expect((Object)executor.shutdownNow()).andReturn((Object)ImmutableList.of()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{executor});
        DelegatingApi api = (DelegatingApi)ContextBuilder.newBuilder((ProviderMetadata)this.provider).modules((Iterable)ImmutableSet.builder().add((Object)new ExecutorServiceModule(executor, executor)).build()).buildApi(DelegatingApi.class);
        api.close();
        EasyMock.verify((Object[])new Object[]{executor});
    }

    static interface DelegatingAsyncApi
    extends Closeable {
    }

    static interface DelegatingApi
    extends Closeable {
    }
}

