/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.predicates.fromconfig;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.jclouds.location.Provider;
import org.jclouds.location.predicates.RegionIdFilter;
import org.jclouds.location.predicates.fromconfig.AnyOrConfiguredRegionId;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AnyOrConfiguredRegionIdTest")
public class AnyOrConfiguredRegionIdTest {
    @Test
    public void testWithoutConfigAllIdsMatch() {
        ImmutableSet regionIds = ImmutableSet.of((Object)"us-east-1", (Object)"eu-west-1");
        RegionIdFilter filter = (RegionIdFilter)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(Provider.class).to("aws-ec2");
            }
        }}).getInstance(AnyOrConfiguredRegionId.class);
        Assert.assertEquals((Set)Sets.filter((Set)regionIds, (Predicate)filter), (Set)ImmutableSet.of((Object)"us-east-1", (Object)"eu-west-1"));
    }

    @Test
    public void testWithConfigOnlyMatchingIds() {
        ImmutableSet regionIds = ImmutableSet.of((Object)"us-east-1", (Object)"eu-west-1");
        RegionIdFilter filter = (RegionIdFilter)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(Provider.class).to("aws-ec2");
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.regions")).to("us-east-1,unknown-1");
            }
        }}).getInstance(AnyOrConfiguredRegionId.class);
        Assert.assertEquals((Set)Sets.filter((Set)regionIds, (Predicate)filter), (Set)ImmutableSet.of((Object)"us-east-1"));
    }
}

