/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.functions;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.net.URI;
import org.jclouds.location.functions.ZoneToEndpoint;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ZoneToEndpointTest")
public class ZoneToEndpointTest {
    @Test
    public void testCorrect() {
        ZoneToEndpoint fn = new ZoneToEndpoint(Suppliers.ofInstance((Object)ImmutableMap.of((Object)"1", (Object)Suppliers.ofInstance((Object)URI.create("http://1")))));
        Assert.assertEquals((Object)fn.apply((Object)"1"), (Object)URI.create("http://1"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeString() {
        ZoneToEndpoint fn = new ZoneToEndpoint(Suppliers.ofInstance((Object)ImmutableMap.of((Object)"1", (Object)Suppliers.ofInstance((Object)URI.create("http://1")))));
        fn.apply((Object)new File("foo"));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testMustHaveEndpoints() {
        ZoneToEndpoint fn = new ZoneToEndpoint(Suppliers.ofInstance((Object)ImmutableMap.of()));
        fn.apply((Object)"1");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNullIsIllegal() {
        ZoneToEndpoint fn = new ZoneToEndpoint(Suppliers.ofInstance((Object)ImmutableMap.of((Object)"1", (Object)Suppliers.ofInstance((Object)URI.create("http://1")))));
        fn.apply(null);
    }
}

