/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.date;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Date;
import org.jclouds.PerformanceTest;
import org.jclouds.date.DateService;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"performance"}, singleThreaded=true, timeOut=120000L, testName="DateServiceTest")
public class DateServiceTest
extends PerformanceTest {
    protected DateService dateService;
    protected TestData[] testData = new TestData[]{new TestData("2009-03-12T02:00:07.000Z", "2009-03-12T06:00:07+0400", "2009-03-12T02:00:07Z", "Thu, 12 Mar 2009 02:00:07 GMT", "Thu Mar 12 02:00:07 +0000 2009", new Date(1236823207000L)), new TestData("2009-03-12T02:00:07.000Z", "2009-03-12T06:00:07+0400", "2009-03-12T02:00:07Z", "Thu, 12 Mar 2009 02:00:07 GMT", "Thu Mar 12 02:00:07 +0000 2009", new Date(1236823207000L)), new TestData("2009-03-14T04:00:07.000Z", "2009-03-14T08:00:07+0400", "2009-03-14T04:00:07Z", "Sat, 14 Mar 2009 04:00:07 GMT", "Thu Mar 14 04:00:07 +0000 2009", new Date(1237003207000L)), new TestData("2009-03-16T06:00:07.000Z", "2009-03-16T10:00:07+0400", "2009-03-16T06:00:07Z", "Mon, 16 Mar 2009 06:00:07 GMT", "Thu Mar 16 06:00:07 +0000 2009", new Date(1237183207000L)), new TestData("2009-03-18T08:00:07.000Z", "2009-03-18T12:00:07+0400", "2009-03-18T08:00:07Z", "Wed, 18 Mar 2009 08:00:07 GMT", "Thu Mar 18 08:00:07 +0000 2009", new Date(1237363207000L)), new TestData("2009-03-20T10:00:07.000Z", "2009-03-20T14:00:07+0400", "2009-03-20T10:00:07Z", "Fri, 20 Mar 2009 10:00:07 GMT", "Thu Mar 20 10:00:07 +0000 2009", new Date(1237543207000L))};

    @BeforeTest
    protected void createDateService() {
        Injector i = Guice.createInjector((Module[])new Module[0]);
        this.dateService = (DateService)i.getInstance(DateService.class);
    }

    @Test
    public void testIso8601DateParse() {
        Date dsDate = this.dateService.iso8601DateParse(this.testData[0].iso8601DateString);
        Assert.assertEquals((Object)dsDate, (Object)this.testData[0].date);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIso8601DateParseIllegal() {
        this.dateService.iso8601DateParse("-1");
    }

    @Test
    public void testIso8601DateParseTz() {
        Date dsDate = this.dateService.iso8601SecondsDateParse(this.testData[0].iso8601DateStringTz);
        Assert.assertEquals((Object)dsDate, (Object)this.testData[0].date);
    }

    @Test
    public void testIso8601DateOrSecondsDateParse() {
        Date dsDate = this.dateService.iso8601DateOrSecondsDateParse(this.testData[0].iso8601DateString);
        Assert.assertEquals((Object)dsDate, (Object)this.testData[0].date);
        Date dsSecondsDate = this.dateService.iso8601DateOrSecondsDateParse(this.testData[0].iso8601SecondsDateString);
        Assert.assertEquals((Object)dsSecondsDate, (Object)this.testData[0].date);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIso8601DateOrSecondsDateParseIllegal() {
        this.dateService.iso8601DateOrSecondsDateParse("-1");
    }

    @Test
    public void testIso8601SecondsDateParse() {
        Date dsDate = this.dateService.iso8601SecondsDateParse(this.testData[0].iso8601SecondsDateString);
        Assert.assertEquals((Object)dsDate, (Object)this.testData[0].date);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIso8601SecondsDateParseIllegal() {
        this.dateService.iso8601SecondsDateParse("-1");
    }

    @Test
    public void testCDateParse() {
        Date dsDate = this.dateService.cDateParse(this.testData[0].cDateString);
        Assert.assertEquals((Object)dsDate, (Object)this.testData[0].date);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testCDateParseIllegal() {
        this.dateService.cDateParse("foo");
    }

    @Test
    public void testRfc822DateParse() {
        Date dsDate = this.dateService.rfc822DateParse(this.testData[0].rfc822DateString);
        Assert.assertEquals((Object)dsDate, (Object)this.testData[0].date);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testRfc822DateParseIllegal() {
        this.dateService.rfc822DateParse("foo");
    }

    @Test
    public void testIso8601DateFormat() {
        String dsString = this.dateService.iso8601DateFormat(this.testData[0].date);
        Assert.assertEquals((String)dsString, (String)this.testData[0].iso8601DateString);
    }

    @Test
    public void testIso8601SecondsDateFormat() {
        String dsString = this.dateService.iso8601SecondsDateFormat(this.testData[0].date);
        Assert.assertEquals((String)dsString, (String)this.testData[0].iso8601SecondsDateString);
    }

    @Test
    public void testCDateFormat() {
        String dsString = this.dateService.cDateFormat(this.testData[0].date);
        Assert.assertEquals((String)dsString, (String)this.testData[0].cDateString);
    }

    @Test
    public void testRfc822DateFormat() {
        String dsString = this.dateService.rfc822DateFormat(this.testData[0].date);
        Assert.assertEquals((String)dsString, (String)this.testData[0].rfc822DateString);
    }

    @Test
    void testIso8601DateFormatResponseTime() {
        for (int i = 0; i < LOOP_COUNT; ++i) {
            this.dateService.iso8601DateFormat();
        }
    }

    @Test
    void testUTCIsGMT() {
        Assert.assertEquals((long)this.dateService.iso8601SecondsDateParse("2012-11-26T17:32:31UTC+0000").getTime(), (long)this.dateService.iso8601SecondsDateParse("2012-11-26T17:32:31UTC+0000").getTime());
    }

    @Test
    void testTz() {
        Assert.assertEquals((long)this.dateService.iso8601SecondsDateParse("2011-05-26T02:14:13-04:00").getTime(), (long)1306390453000L);
    }

    @Test
    void testTzNoT() {
        Assert.assertEquals((long)this.dateService.iso8601DateParse("2011-05-25 16:12:21.656+0000").getTime(), (long)1306339941656L);
    }

    @Test
    void testRfc822DateFormatResponseTime() {
        for (int i = 0; i < LOOP_COUNT; ++i) {
            this.dateService.rfc822DateFormat();
        }
    }

    @Test
    void testCDateFormatResponseTime() {
        for (int i = 0; i < LOOP_COUNT; ++i) {
            this.dateService.cDateFormat();
        }
    }

    @Test
    void testFormatIso8601DateCorrectnessInParallel() throws Throwable {
        ArrayList tasks = Lists.newArrayListWithCapacity((int)this.testData.length);
        for (final TestData myData : this.testData) {
            tasks.add(new Runnable(){

                @Override
                public void run() {
                    String dsString = DateServiceTest.this.dateService.iso8601DateFormat(myData.date);
                    Assert.assertEquals((String)dsString, (String)myData.iso8601DateString);
                }
            });
        }
        this.executeMultiThreadedCorrectnessTest(tasks);
    }

    @Test
    void testFormatIso8601DatePerformanceInParallel() throws Throwable {
        ArrayList tasks = Lists.newArrayListWithCapacity((int)this.testData.length);
        for (final TestData myData : this.testData) {
            tasks.add(new Runnable(){

                @Override
                public void run() {
                    DateServiceTest.this.dateService.iso8601DateFormat(myData.date);
                }
            });
        }
        this.executeMultiThreadedPerformanceTest("testFormatIso8601DatePerformanceInParallel", tasks);
    }

    @Test
    void testParseIso8601DateSerialResponseTime() {
        for (int i = 0; i < LOOP_COUNT; ++i) {
            this.dateService.iso8601DateParse(this.testData[0].iso8601DateString);
        }
    }

    @Test
    void testParseIso8601DateCorrectnessInParallel() throws Throwable {
        ArrayList tasks = Lists.newArrayListWithCapacity((int)this.testData.length);
        for (final TestData myData : this.testData) {
            tasks.add(new Runnable(){

                @Override
                public void run() {
                    Date dsDate = DateServiceTest.this.dateService.iso8601DateParse(myData.iso8601DateString);
                    Assert.assertEquals((Object)dsDate, (Object)myData.date);
                }
            });
        }
        this.executeMultiThreadedCorrectnessTest(tasks);
    }

    @Test
    void testParseIso8601DatePerformanceInParallel() throws Throwable {
        ArrayList tasks = Lists.newArrayListWithCapacity((int)this.testData.length);
        for (final TestData myData : this.testData) {
            tasks.add(new Runnable(){

                @Override
                public void run() {
                    DateServiceTest.this.dateService.iso8601DateParse(myData.iso8601DateString);
                }
            });
        }
        this.executeMultiThreadedPerformanceTest("testParseIso8601DatePerformanceInParallel", tasks);
    }

    protected class TestData {
        public final String iso8601DateString;
        public final String iso8601DateStringTz;
        public final String iso8601SecondsDateString;
        public final String rfc822DateString;
        public final String cDateString;
        public final Date date;

        TestData(String iso8601, String iso8601DateStringTz, String iso8601Seconds, String rfc822, String cDateString, Date dateTime) {
            this.iso8601DateString = iso8601;
            this.iso8601DateStringTz = iso8601DateStringTz;
            this.iso8601SecondsDateString = iso8601Seconds;
            this.rfc822DateString = rfc822;
            this.cDateString = cDateString;
            this.date = dateTime;
        }
    }
}

