/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent.config;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutionException;
import org.easymock.EasyMock;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.concurrent.config.WithSubmissionTrace;
import org.jclouds.lifecycle.Closer;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class ExecutorServiceModuleTest {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Injector injector;

    @BeforeClass
    private void setupExecutorModule() {
        ExecutorServiceModule module = new ExecutorServiceModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.io-worker-threads")).to(1);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.user-threads")).to(1);
                super.configure();
            }
        };
        this.injector = Guice.createInjector((Module[])new Module[]{module});
        Assert.assertNull((Object)module.userExecutorFromConstructor);
        Assert.assertNull((Object)module.ioExecutorFromConstructor);
    }

    @AfterClass
    private void close() throws IOException {
        ListeningExecutorService user = (ListeningExecutorService)this.injector.getInstance(Key.get(ListeningExecutorService.class, (Annotation)Names.named((String)"jclouds.user-threads")));
        ListeningExecutorService io = (ListeningExecutorService)this.injector.getInstance(Key.get(ListeningExecutorService.class, (Annotation)Names.named((String)"jclouds.io-worker-threads")));
        ((Closer)this.injector.getInstance(Closer.class)).close();
        Assert.assertTrue((boolean)user.isShutdown());
        Assert.assertTrue((boolean)io.isShutdown());
    }

    @Test
    public void testShutdownOnClose() throws IOException {
        Injector i = Guice.createInjector((Module[])new Module[0]);
        Closer closer = (Closer)i.getInstance(Closer.class);
        ListeningExecutorService executor = (ListeningExecutorService)EasyMock.createMock(ListeningExecutorService.class);
        ExecutorServiceModule.shutdownOnClose((ListeningExecutorService)executor, (Closer)closer);
        EasyMock.expect((Object)executor.shutdownNow()).andReturn((Object)ImmutableList.of()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{executor});
        closer.close();
        EasyMock.verify((Object[])new Object[]{executor});
    }

    @Test(timeOut=5000L)
    public void testExceptionInSubmitRunnableIncludesSubmissionTrace() throws Exception {
        ListeningExecutorService user = (ListeningExecutorService)this.injector.getInstance(Key.get(ListeningExecutorService.class, (Annotation)Names.named((String)"jclouds.user-threads")));
        ListeningExecutorService io = (ListeningExecutorService)this.injector.getInstance(Key.get(ListeningExecutorService.class, (Annotation)Names.named((String)"jclouds.io-worker-threads")));
        for (ListeningExecutorService exec : ImmutableList.of((Object)user, (Object)io)) {
            String submission = null;
            try {
                submission = Throwables.getStackTraceAsString((Throwable)ExecutorServiceModuleTest.incrementInitialElement(new RuntimeException(), 2)).replaceFirst(String.format(".*%s", LINE_SEPARATOR), "");
                exec.submit(ExecutorServiceModuleTest.runnableThrowsRTE()).get();
            }
            catch (ExecutionException e) {
                ExecutorServiceModuleTest.assertTraceHasSubmission(Throwables.getStackTraceAsString((Throwable)e), submission);
                ExecutorServiceModuleTest.assertTraceHasSubmission(Throwables.getStackTraceAsString((Throwable)e.getCause()), submission);
            }
        }
    }

    static void assertTraceHasSubmission(String trace, String expected) {
        Assert.assertEquals((int)trace.indexOf(WithSubmissionTrace.class.getName()), (int)-1, (String)trace);
        Assert.assertNotEquals((Object)trace.indexOf(expected), (Object)-1, (String)(trace + " " + expected));
    }

    static <E extends Exception> E incrementInitialElement(E ex, int lines) {
        StackTraceElement[] trace = ex.getStackTrace();
        StackTraceElement initialElement = trace[0];
        trace[0] = new StackTraceElement(initialElement.getClassName(), initialElement.getMethodName(), initialElement.getFileName(), initialElement.getLineNumber() + lines);
        ex.setStackTrace(trace);
        return ex;
    }

    static Runnable runnableThrowsRTE() {
        return new Runnable(){

            @Override
            public void run() {
                throw new RuntimeException();
            }
        };
    }
}

