/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.apis.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Set;
import org.jclouds.View;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.Apis;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public abstract class BaseApiMetadataTest {
    protected final ApiMetadata toTest;
    protected final Set<TypeToken<? extends View>> views;

    public BaseApiMetadataTest(ApiMetadata toTest, Set<TypeToken<? extends View>> views) {
        this.toTest = toTest;
        this.views = views;
    }

    @Test
    public void testWithId() {
        ApiMetadata apiMetadata = Apis.withId((String)this.toTest.getId());
        Assert.assertEquals((Object)this.toTest, (Object)apiMetadata);
    }

    @Test
    public void testTransformableToContains() {
        for (TypeToken<? extends View> view : this.views) {
            ImmutableSet ofType = ImmutableSet.copyOf((Iterable)Apis.viewableAs(view));
            assert (ofType.contains((Object)this.toTest)) : String.format("%s not found in %s for %s", this.toTest, ofType, view);
        }
    }

    @Test
    public void testAllContains() {
        ImmutableSet all = ImmutableSet.copyOf((Iterable)Apis.all());
        assert (all.contains((Object)this.toTest)) : String.format("%s not found in %s", this.toTest, all);
    }
}

