/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.util.List;
import org.jclouds.JcloudsVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class JcloudsVersionTest {
    @Test(expectedExceptions={NullPointerException.class})
    public void testFailsIfResourceFileMissing() {
        new JcloudsVersion((ClassLoader)new ResourceHidingClassLoader(JcloudsVersion.class.getClassLoader(), new String[]{"META-INF/maven/arre.jclouds/jclouds-core/pom.properties"}));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testFailsIfInvalidVersion() {
        new JcloudsVersion("${project.version}");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testFailsIfNonSemverReleaseCandidate() {
        new JcloudsVersion("1.2.3-rc-4");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testFailsIfIncubating() {
        new JcloudsVersion("1.2.3-incubating");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testFailsIfAlphaSnapshot() {
        new JcloudsVersion("1.2.3-alpha.5-SNAPSHOT");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testFailsIfBetaSnapshot() {
        new JcloudsVersion("1.2.3-beta.5-SNAPSHOT");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testFailsIfReleaseCandidateSnapshot() {
        new JcloudsVersion("1.2.3-rc.4-SNAPSHOT");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testFailsIfIncubatingSnapshot() {
        new JcloudsVersion("1.2.3-incubating-SNAPSHOT");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testFailsIfNumberedIncubating() {
        new JcloudsVersion("1.2.3-incubating.1");
    }

    @Test
    public void testExtractsVersionFromResourceFile() {
        JcloudsVersion version = new JcloudsVersion();
        Assert.assertEquals((String)"0.0.0-SNAPSHOT", (String)version.toString());
    }

    @Test
    public void testExtractsMajorMinorPatchVersions() {
        JcloudsVersion version = new JcloudsVersion("1.2.3");
        Assert.assertEquals((int)1, (int)version.majorVersion);
        Assert.assertEquals((int)2, (int)version.minorVersion);
        Assert.assertEquals((int)3, (int)version.patchVersion);
    }

    @Test
    public void testSupportsNonSnapshot() {
        JcloudsVersion version = new JcloudsVersion("1.2.3");
        Assert.assertFalse((boolean)version.snapshot, (String)"Expected non-snapshot");
    }

    @Test
    public void testRecognisesSnapshot() {
        JcloudsVersion version = new JcloudsVersion("1.2.3-SNAPSHOT");
        Assert.assertTrue((boolean)version.snapshot, (String)"Expected snapshot");
    }

    @Test
    public void testSupportsReleaseVersion() {
        JcloudsVersion version = new JcloudsVersion("1.2.3");
        Assert.assertFalse((boolean)version.alpha, (String)"Expected non-alpha");
        Assert.assertFalse((boolean)version.beta, (String)"Expected non-beta");
        Assert.assertFalse((boolean)version.releaseCandidate, (String)"Expected non-release candidate");
        Assert.assertNull((Object)version.alphaVersion);
        Assert.assertNull((Object)version.betaVersion);
        Assert.assertNull((Object)version.releaseCandidateVersion);
    }

    @Test
    public void testRecognisesAlpha() {
        JcloudsVersion version = new JcloudsVersion("1.2.3-alpha.5");
        Assert.assertTrue((boolean)version.alpha, (String)"Expected alpha");
    }

    @Test
    public void testExtractsAlphaVersion() {
        JcloudsVersion version = new JcloudsVersion("1.2.3-alpha.5");
        Assert.assertEquals((Object)5, (Object)version.alphaVersion);
    }

    @Test
    public void testRecognisesBeta() {
        JcloudsVersion version = new JcloudsVersion("1.2.3-beta.5");
        Assert.assertTrue((boolean)version.beta, (String)"Expected beta");
    }

    @Test
    public void testExtractsBetaVersion() {
        JcloudsVersion version = new JcloudsVersion("1.2.3-beta.5");
        Assert.assertEquals((Object)5, (Object)version.betaVersion);
    }

    @Test
    public void testRecognisesReleaseCandidate() {
        JcloudsVersion version = new JcloudsVersion("1.2.3-rc.4");
        Assert.assertTrue((boolean)version.releaseCandidate, (String)"Expected release candidate");
    }

    @Test
    public void testExtractsReleaseCandidateVersion() {
        JcloudsVersion version = new JcloudsVersion("1.2.3-rc.4");
        Assert.assertEquals((Object)4, (Object)version.releaseCandidateVersion);
    }

    private static class ResourceHidingClassLoader
    extends ClassLoader {
        private final ClassLoader delegate;
        private final List<String> resourcesToHide;

        private ResourceHidingClassLoader(ClassLoader delegate, String ... resourcesToHide) {
            this.delegate = delegate;
            this.resourcesToHide = ImmutableList.copyOf((Object[])resourcesToHide);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return Iterables.contains(this.resourcesToHide, (Object)name) ? null : this.delegate.getResourceAsStream(name);
        }
    }
}

