/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.CreationException;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Message;
import java.io.IOException;
import java.net.SocketException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.easymock.EasyMock;
import org.jclouds.concurrent.TransformParallelException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponseException;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Throwables2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class Throwables2Test {
    public void testGetFirstThrowableOfTypeSubclass() {
        SocketException aex = (SocketException)EasyMock.createMock(SocketException.class);
        Assert.assertEquals((Object)Throwables2.getFirstThrowableOfType((Throwable)aex, IOException.class), (Object)aex);
    }

    public void testGetFirstThrowableOfTypeOuter() {
        AuthorizationException aex = (AuthorizationException)((Object)EasyMock.createMock(AuthorizationException.class));
        Assert.assertEquals((Object)Throwables2.getFirstThrowableOfType((Throwable)aex, AuthorizationException.class), (Object)((Object)aex));
    }

    public void testGetCause() {
        AuthorizationException aex = (AuthorizationException)((Object)EasyMock.createMock(AuthorizationException.class));
        Message message = new Message((List)ImmutableList.of(), "test", (Throwable)aex);
        ProvisionException pex = new ProvisionException((Iterable)ImmutableSet.of((Object)message));
        Assert.assertEquals((Object)Throwables2.getFirstThrowableOfType((ProvisionException)pex, AuthorizationException.class), (Object)((Object)aex));
    }

    public void testGetFirstThrowableOfTypeInner() {
        AuthorizationException aex = (AuthorizationException)((Object)EasyMock.createMock(AuthorizationException.class));
        Message message = new Message((List)ImmutableList.of(), "test", (Throwable)aex);
        ProvisionException pex = new ProvisionException((Iterable)ImmutableSet.of((Object)message));
        Assert.assertEquals((Object)Throwables2.getFirstThrowableOfType((ProvisionException)pex, AuthorizationException.class), (Object)((Object)aex));
    }

    public void testGetFirstThrowableOfTypeFail() {
        TimeoutException aex = (TimeoutException)EasyMock.createMock(TimeoutException.class);
        Message message = new Message((List)ImmutableList.of(), "test", (Throwable)aex);
        ProvisionException pex = new ProvisionException((Iterable)ImmutableSet.of((Object)message));
        Assert.assertEquals((Object)Throwables2.getFirstThrowableOfType((ProvisionException)pex, AuthorizationException.class), null);
    }

    public void testGetFirstThrowableOfTypeWhenCauseIsNull() {
        Message message = new Message((List)ImmutableList.of(), "test", null);
        ProvisionException pex = new ProvisionException((Iterable)ImmutableSet.of((Object)message));
        Assert.assertEquals((Object)Throwables2.getFirstThrowableOfType((ProvisionException)pex, AuthorizationException.class), null);
    }

    public void testGetCauseCreation() {
        AuthorizationException aex = (AuthorizationException)((Object)EasyMock.createMock(AuthorizationException.class));
        Message message = new Message((List)ImmutableList.of(), "test", (Throwable)aex);
        CreationException pex = new CreationException((Collection)ImmutableSet.of((Object)message));
        Assert.assertEquals((Object)Throwables2.getFirstThrowableOfType((CreationException)pex, AuthorizationException.class), (Object)((Object)aex));
    }

    public void testGetFirstThrowableOfTypeInnerCreation() {
        AuthorizationException aex = (AuthorizationException)((Object)EasyMock.createMock(AuthorizationException.class));
        Message message = new Message((List)ImmutableList.of(), "test", (Throwable)aex);
        CreationException pex = new CreationException((Collection)ImmutableSet.of((Object)message));
        Assert.assertEquals((Object)Throwables2.getFirstThrowableOfType((CreationException)pex, AuthorizationException.class), (Object)((Object)aex));
    }

    public void testGetFirstThrowableOfTypeFailCreation() {
        TimeoutException aex = (TimeoutException)EasyMock.createMock(TimeoutException.class);
        Message message = new Message((List)ImmutableList.of(), "test", (Throwable)aex);
        CreationException pex = new CreationException((Collection)ImmutableSet.of((Object)message));
        Assert.assertEquals((Object)Throwables2.getFirstThrowableOfType((CreationException)pex, AuthorizationException.class), null);
    }

    public void testGetFirstThrowableOfTypeWhenCauseIsNullCreation() {
        Message message = new Message((List)ImmutableList.of(), "test", null);
        CreationException pex = new CreationException((Collection)ImmutableSet.of((Object)message));
        Assert.assertEquals((Object)Throwables2.getFirstThrowableOfType((CreationException)pex, AuthorizationException.class), null);
    }

    public void testGetCauseTransformParallel() {
        Exception aex = (Exception)EasyMock.createMock(AuthorizationException.class);
        TransformParallelException pex = new TransformParallelException((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"bad", (Object)aex), "test");
        Assert.assertEquals((Object)Throwables2.getFirstThrowableOfType((TransformParallelException)pex, AuthorizationException.class), (Object)aex);
    }

    public void testGetFirstThrowableOfTypeInnerTransformParallel() {
        Exception aex = (Exception)EasyMock.createMock(AuthorizationException.class);
        TransformParallelException pex = new TransformParallelException((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"bad", (Object)new ExecutionException(aex)), "test");
        Assert.assertEquals((Object)Throwables2.getFirstThrowableOfType((TransformParallelException)pex, AuthorizationException.class), (Object)aex);
    }

    public void testGetFirstThrowableOfTypeOuterTransformParallel() {
        Exception aex = (Exception)EasyMock.createMock(AuthorizationException.class);
        TransformParallelException pex = new TransformParallelException((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"bad", (Object)aex), "test");
        Assert.assertEquals((Object)Throwables2.getFirstThrowableOfType((Throwable)new ExecutionException(pex), AuthorizationException.class), (Object)aex);
    }

    public void testGetFirstThrowableOfTypeFailTransformParallel() {
        Exception aex = (Exception)EasyMock.createMock(TimeoutException.class);
        TransformParallelException pex = new TransformParallelException((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"bad", (Object)aex), "test");
        Assert.assertEquals((Object)Throwables2.getFirstThrowableOfType((TransformParallelException)pex, AuthorizationException.class), null);
    }

    @Test(expectedExceptions={TestException.class})
    public void testPropagateExceptionThatsInList() throws Throwable {
        TestException e = new TestException();
        Throwables2.propagateIfPossible((Throwable)e, (Iterable)ImmutableSet.of((Object)Reflection2.typeToken(TestException.class)));
    }

    @Test(expectedExceptions={TestException.class})
    public void testPropagateWrappedExceptionThatsInList() throws Throwable {
        TestException e = new TestException();
        Throwables2.propagateIfPossible((Throwable)new RuntimeException(e), (Iterable)ImmutableSet.of((Object)Reflection2.typeToken(TestException.class)));
    }

    public void testPropagateIfPossibleDoesnThrowExceptionNotInList() throws Throwable {
        TestException e = new TestException();
        Throwables2.propagateIfPossible((Throwable)e, (Iterable)ImmutableSet.of());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testPropagateStandardExceptionIllegalStateException() throws Throwable {
        IllegalStateException e = new IllegalStateException();
        Throwables2.propagateIfPossible((Throwable)new RuntimeException(e), (Iterable)ImmutableSet.of());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testPropagateStandardExceptionIllegalArgumentException() throws Throwable {
        IllegalArgumentException e = new IllegalArgumentException();
        Throwables2.propagateIfPossible((Throwable)new RuntimeException(e), (Iterable)ImmutableSet.of());
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPropagateStandardExceptionUnsupportedOperationException() throws Throwable {
        UnsupportedOperationException e = new UnsupportedOperationException();
        Throwables2.propagateIfPossible((Throwable)new RuntimeException(e), (Iterable)ImmutableSet.of());
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPropagateStandardExceptionAssertionError() throws Throwable {
        AssertionError e = new AssertionError();
        Throwables2.propagateIfPossible((Throwable)new RuntimeException((Throwable)((Object)e)), (Iterable)ImmutableSet.of());
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testPropagateStandardExceptionAuthorizationException() throws Throwable {
        AuthorizationException e = new AuthorizationException();
        Throwables2.propagateIfPossible((Throwable)new RuntimeException(e), (Iterable)ImmutableSet.of());
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testPropagateProvisionExceptionAuthorizationException() throws Throwable {
        AuthorizationException e = new AuthorizationException();
        Throwables2.propagateIfPossible((Throwable)new ProvisionException((Iterable)ImmutableSet.of((Object)new Message((List)ImmutableList.of(), "Error in custom provider", (Throwable)e))), (Iterable)ImmutableSet.of());
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testPropagateCreationExceptionAuthorizationException() throws Throwable {
        AuthorizationException e = new AuthorizationException();
        Throwables2.propagateIfPossible((Throwable)new CreationException((Collection)ImmutableSet.of((Object)new Message((List)ImmutableList.of(), "Error in custom provider", (Throwable)e))), (Iterable)ImmutableSet.of());
    }

    @Test(expectedExceptions={InsufficientResourcesException.class})
    public void testPropagateStandardExceptionInsufficientResourcesException() throws Throwable {
        InsufficientResourcesException e = new InsufficientResourcesException();
        Throwables2.propagateIfPossible((Throwable)new RuntimeException((Throwable)e), (Iterable)ImmutableSet.of());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testPropagateStandardExceptionResourceNotFoundException() throws Throwable {
        ResourceNotFoundException e = new ResourceNotFoundException();
        Throwables2.propagateIfPossible((Throwable)new RuntimeException((Throwable)e), (Iterable)ImmutableSet.of());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testPropagateStandardExceptionIllegalStateExceptionNestedInHttpResponseException() throws Throwable {
        IllegalStateException e = new IllegalStateException();
        Throwables2.propagateIfPossible((Throwable)new HttpResponseException("goo", (HttpCommand)EasyMock.createNiceMock(HttpCommand.class), null, (Throwable)e), (Iterable)ImmutableSet.of());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testPropagateStandardExceptionIllegalArgumentExceptionNestedInHttpResponseException() throws Throwable {
        IllegalArgumentException e = new IllegalArgumentException();
        Throwables2.propagateIfPossible((Throwable)new HttpResponseException("goo", (HttpCommand)EasyMock.createNiceMock(HttpCommand.class), null, (Throwable)e), (Iterable)ImmutableSet.of());
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPropagateStandardExceptionUnsupportedOperationExceptionNestedInHttpResponseException() throws Throwable {
        UnsupportedOperationException e = new UnsupportedOperationException();
        Throwables2.propagateIfPossible((Throwable)new HttpResponseException("goo", (HttpCommand)EasyMock.createNiceMock(HttpCommand.class), null, (Throwable)e), (Iterable)ImmutableSet.of());
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testPropagateStandardExceptionAuthorizationExceptionNestedInHttpResponseException() throws Throwable {
        AuthorizationException e = new AuthorizationException();
        Throwables2.propagateIfPossible((Throwable)new HttpResponseException("goo", (HttpCommand)EasyMock.createNiceMock(HttpCommand.class), null, (Throwable)e), (Iterable)ImmutableSet.of());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testPropagateStandardExceptionResourceNotFoundExceptionNestedInHttpResponseException() throws Throwable {
        ResourceNotFoundException e = new ResourceNotFoundException();
        Throwables2.propagateIfPossible((Throwable)new HttpResponseException("goo", (HttpCommand)EasyMock.createNiceMock(HttpCommand.class), null, (Throwable)e), (Iterable)ImmutableSet.of());
    }

    @Test(expectedExceptions={HttpResponseException.class})
    public void testPropagateStandardExceptionHttpResponseException() throws Throwable {
        HttpResponseException e = new HttpResponseException("goo", (HttpCommand)EasyMock.createNiceMock(HttpCommand.class), null);
        Throwables2.propagateIfPossible((Throwable)new RuntimeException(e), (Iterable)ImmutableSet.of());
    }

    static class TestException
    extends Exception {
        private static final long serialVersionUID = 1L;

        TestException() {
        }
    }
}

