/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.annotationparsing;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Module;
import java.util.Map;
import javax.ws.rs.FormParam;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.rest.internal.BaseRestClientExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DelegateAnnotationExpectTest")
public class DelegateAnnotationExpectTest
extends BaseRestClientExpectTest<DelegatingApi> {
    public void testDelegatingCallTakesIntoConsiderationAndCalleeFormParam() {
        DelegatingApi client = (DelegatingApi)this.requestSendsResponse(HttpRequest.builder().method("POST").endpoint("http://mock").addFormParam("project", new String[]{"prod"}).build(), HttpResponse.builder().statusCode(200).build());
        client.getDiskApiForProjectForm("prod").form();
    }

    public void testDelegatingCallTakesIntoConsiderationAndCalleePayloadParam() {
        DelegatingApi client = (DelegatingApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("http://mock/projects/prod").payload("<Sync>prod</Sync>")).build(), HttpResponse.builder().statusCode(200).build());
        client.getDiskApiForProject("prod").syncAll();
    }

    public void testDelegatingCallTakesIntoConsiderationCallerAndCalleePath() {
        DelegatingApi client = (DelegatingApi)this.requestSendsResponse(HttpRequest.builder().method("HEAD").endpoint("http://mock/projects/prod/disks/disk1").build(), HttpResponse.builder().statusCode(200).build());
        Assert.assertTrue((boolean)client.getDiskApiForProject("prod").exists("disk1"));
    }

    @Override
    public ProviderMetadata createProviderMetadata() {
        return AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(DelegatingApi.class, DelegatingAsyncApi.class, (String)"http://mock");
    }

    @Override
    protected Module createModule() {
        return new DelegatingRestClientModule();
    }

    @ConfiguresRestClient
    static class DelegatingRestClientModule
    extends RestClientModule<DelegatingApi, DelegatingAsyncApi> {
        public DelegatingRestClientModule() {
            super((Map)ImmutableMap.of(DiskApi.class, DiskAsyncApi.class));
        }
    }

    static interface DiskAsyncApi {
        @POST
        public ListenableFuture<Void> form();

        @POST
        @Payload(value="<Sync>{project}</Sync>")
        public ListenableFuture<Void> syncAll();

        @HEAD
        @Path(value="/disks/{disk}")
        @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
        public ListenableFuture<Boolean> exists(@PathParam(value="disk") String var1);
    }

    static interface DiskApi {
        public void form();

        public void syncAll();

        public boolean exists(@PathParam(value="disk") String var1);
    }

    static interface DelegatingAsyncApi {
        @Delegate
        public DiskAsyncApi getDiskApiForProjectForm(@FormParam(value="project") String var1);

        @Delegate
        @Path(value="/projects/{project}")
        public DiskAsyncApi getDiskApiForProject(@PayloadParam(value="project") @PathParam(value="project") String var1);
    }

    static interface DelegatingApi {
        @Delegate
        public DiskApi getDiskApiForProjectForm(@FormParam(value="project") String var1);

        @Delegate
        @Path(value="/projects/{project}")
        public DiskApi getDiskApiForProject(@PayloadParam(value="project") @PathParam(value="project") String var1);
    }
}

