/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.reflect;

import com.google.common.base.Throwables;
import com.google.common.cache.ForwardingLoadingCache;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import org.jclouds.reflect.Reflection2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class Reflection2OverriddenMethodTest {
    private LoadingCache<TypeToken<?>, Set<Invokable<?, ?>>> originalMethodsForTypeToken;

    @BeforeClass
    public void backupMethodsForTypeToken() {
        this.originalMethodsForTypeToken = (LoadingCache)Reflection2OverriddenMethodTest.getStaticField(Reflection2.class, "methodsForTypeToken");
    }

    public void testOverriddenMethodWithNarrowedReturnType() throws NoSuchMethodException {
        Method[] methods = ChildOverridesAndNarrowsMethod.class.getDeclaredMethods();
        Reflection2OverriddenMethodTest.setStaticField(Reflection2.class, "methodsForTypeToken", this.keyOverridingCache((TypeToken<?>)TypeToken.of(ChildOverridesAndNarrowsMethod.class), (Set<Invokable<?, ?>>)ImmutableSet.of((Object)Invokable.from((Method)methods[0]), (Object)Invokable.from((Method)methods[1]))));
        Invokable mostSpecificMethod = Invokable.from((Method)ChildOverridesAndNarrowsMethod.class.getMethod("method", new Class[0]));
        Assert.assertEquals((Object)Reflection2.method(ChildOverridesAndNarrowsMethod.class, (String)"method", (Class[])new Class[0]), (Object)mostSpecificMethod);
        ((LoadingCache)Reflection2OverriddenMethodTest.getStaticField(Reflection2.class, "methodForParams")).invalidateAll();
        Reflection2OverriddenMethodTest.setStaticField(Reflection2.class, "methodsForTypeToken", this.keyOverridingCache((TypeToken<?>)TypeToken.of(ChildOverridesAndNarrowsMethod.class), (Set<Invokable<?, ?>>)ImmutableSet.of((Object)Invokable.from((Method)methods[1]), (Object)Invokable.from((Method)methods[0]))));
        Assert.assertEquals((Object)Reflection2.method(ChildOverridesAndNarrowsMethod.class, (String)"method", (Class[])new Class[0]), (Object)mostSpecificMethod);
    }

    private LoadingCache<TypeToken<?>, Set<Invokable<?, ?>>> keyOverridingCache(final TypeToken<?> overriddenKey, final Set<Invokable<?, ?>> value) {
        return new ForwardingLoadingCache.SimpleForwardingLoadingCache<TypeToken<?>, Set<Invokable<?, ?>>>(this.originalMethodsForTypeToken){

            public Set<Invokable<?, ?>> get(TypeToken<?> key) throws ExecutionException {
                return key.equals((Object)overriddenKey) ? value : (Set)super.get(key);
            }
        };
    }

    private static <T> T getStaticField(Class<?> declaringClass, String fieldName) {
        try {
            Field field = declaringClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(null);
        }
        catch (NoSuchFieldException exception) {
            throw Throwables.propagate((Throwable)exception);
        }
        catch (IllegalAccessException exception) {
            throw Throwables.propagate((Throwable)exception);
        }
    }

    private static void setStaticField(Class<?> declaringClass, String fieldName, Object value) {
        try {
            Field field = declaringClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(null, value);
        }
        catch (NoSuchFieldException exception) {
            throw Throwables.propagate((Throwable)exception);
        }
        catch (IllegalAccessException exception) {
            throw Throwables.propagate((Throwable)exception);
        }
    }

    @AfterClass(alwaysRun=true)
    public void restoreMethodsForTypeToken() {
        Reflection2OverriddenMethodTest.setStaticField(Reflection2.class, "methodsForTypeToken", this.originalMethodsForTypeToken);
    }

    private static class ChildOverridesAndNarrowsMethod
    extends ParentWithMethod {
        private ChildOverridesAndNarrowsMethod() {
        }

        public SortedSet<Object> method() {
            return null;
        }
    }

    private static class ParentWithMethod {
        private ParentWithMethod() {
        }

        public Set<Object> method() {
            return null;
        }
    }
}

