/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.implicit;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.util.NoSuchElementException;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.implicit.OnlyLocationOrFirstRegionOptionallyMatchingRegionId;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="OnlyLocationOrFirstRegionOptionallyMatchingRegionIdTest")
public class OnlyLocationOrFirstRegionOptionallyMatchingRegionIdTest {
    Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id("servo").description("http://servo").build();
    Location region = new LocationBuilder().scope(LocationScope.REGION).id("servo-r1").description("http://r1.servo").parent(this.provider).build();
    Location region2 = new LocationBuilder().scope(LocationScope.REGION).id("servo-r2").description("http://r2.servo").parent(this.provider).build();
    Location zone = new LocationBuilder().scope(LocationScope.ZONE).id("servo-z").description("http://z.r.servo").parent(this.region).build();

    @Test
    public void testDidntMatchRegionIdThrowsNSEEWithReasonableMessage() {
        Supplier supplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.provider, (Object)this.region, (Object)this.region2, (Object)this.zone));
        OnlyLocationOrFirstRegionOptionallyMatchingRegionId fn = new OnlyLocationOrFirstRegionOptionallyMatchingRegionId(Suppliers.ofInstance((Object)"foo"), supplier);
        try {
            fn.get();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"couldn't find region matching isRegionAndIdEqualsOrIsZoneParentIdEquals(foo) in [servo:PROVIDER, servo-r1:REGION, servo-r2:REGION, servo-z:ZONE]");
        }
    }

    @Test
    public void testNoRegionUsesProvider() {
        Supplier supplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.provider));
        OnlyLocationOrFirstRegionOptionallyMatchingRegionId fn = new OnlyLocationOrFirstRegionOptionallyMatchingRegionId(Suppliers.ofInstance(null), supplier);
        Assert.assertEquals((Object)fn.get(), (Object)this.provider);
    }

    @Test
    public void testFirstRegion() {
        Supplier supplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.provider, (Object)this.region, (Object)this.region2, (Object)this.zone));
        OnlyLocationOrFirstRegionOptionallyMatchingRegionId fn = new OnlyLocationOrFirstRegionOptionallyMatchingRegionId(Suppliers.ofInstance(null), supplier);
        Assert.assertEquals((Object)fn.get(), (Object)this.region);
    }

    @Test
    public void testFindRegion() {
        Supplier supplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.provider, (Object)this.region, (Object)this.region2, (Object)this.zone));
        OnlyLocationOrFirstRegionOptionallyMatchingRegionId fn = new OnlyLocationOrFirstRegionOptionallyMatchingRegionId(Suppliers.ofInstance((Object)this.region2.getId()), supplier);
        Assert.assertEquals((Object)fn.get(), (Object)this.region2);
    }
}

