/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.functions;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.net.URI;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RegionToEndpointOrProviderIfNullTest")
public class RegionToEndpointOrProviderIfNullTest {
    @Test
    public void testWhenRegionNameIsSameAsProviderName() throws SecurityException, NoSuchMethodException {
        RegionToEndpointOrProviderIfNull fn = new RegionToEndpointOrProviderIfNull("leader", Suppliers.ofInstance((Object)URI.create("http://leader")), Suppliers.ofInstance((Object)ImmutableMap.of((Object)"leader", (Object)Suppliers.ofInstance((Object)URI.create("http://leaderregion")))));
        Assert.assertEquals((Object)fn.apply((Object)"leader"), (Object)URI.create("http://leaderregion"));
    }

    @Test
    public void testWhenFindsRegion() throws SecurityException, NoSuchMethodException {
        RegionToEndpointOrProviderIfNull fn = new RegionToEndpointOrProviderIfNull("leader", Suppliers.ofInstance((Object)URI.create("http://leader")), Suppliers.ofInstance((Object)ImmutableMap.of((Object)"1", (Object)Suppliers.ofInstance((Object)URI.create("http://1")))));
        Assert.assertEquals((Object)fn.apply((Object)"1"), (Object)URI.create("http://1"));
    }

    public void testNullReturnsProvider() {
        RegionToEndpointOrProviderIfNull fn = new RegionToEndpointOrProviderIfNull("leader", Suppliers.ofInstance((Object)URI.create("http://leader")), Suppliers.ofInstance((Object)ImmutableMap.of((Object)"1", (Object)Suppliers.ofInstance((Object)URI.create("http://1")))));
        Assert.assertEquals((Object)fn.apply((Object)"leader"), (Object)URI.create("http://leader"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeString() {
        RegionToEndpointOrProviderIfNull fn = new RegionToEndpointOrProviderIfNull("leader", Suppliers.ofInstance((Object)URI.create("http://leader")), Suppliers.ofInstance((Object)ImmutableMap.of((Object)"1", (Object)Suppliers.ofInstance((Object)URI.create("http://1")))));
        fn.apply((Object)new File("foo"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeInRegionMapIfSpecified() {
        RegionToEndpointOrProviderIfNull fn = new RegionToEndpointOrProviderIfNull("leader", Suppliers.ofInstance((Object)URI.create("http://leader")), Suppliers.ofInstance((Object)ImmutableMap.of((Object)"1", (Object)Suppliers.ofInstance((Object)URI.create("http://1")))));
        fn.apply((Object)"2");
    }

    public void testOkIfNoRegionMappings() {
        new RegionToEndpointOrProviderIfNull("leader", Suppliers.ofInstance((Object)URI.create("http://leader")), Suppliers.ofInstance((Object)ImmutableMap.of()));
    }
}

