/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.TransformingMap;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.json.Json;
import org.jclouds.logging.Logger;
import org.jclouds.rest.ConfiguresCredentialStore;

@ConfiguresCredentialStore
@Beta
public class CredentialStoreModule
extends AbstractModule {
    private static final Map<String, ByteSource> BACKING = new ConcurrentHashMap<String, ByteSource>();
    private final Map<String, ByteSource> backing;

    public CredentialStoreModule(Map<String, ByteSource> backing) {
        this.backing = backing;
    }

    public CredentialStoreModule() {
        this(null);
    }

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Function<Credentials, ByteSource>>(){}).to(CredentialsToJsonByteSource.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ByteSource, Credentials>>(){}).to(CredentialsFromJsonByteSource.class);
        if (this.backing != null) {
            this.bind((TypeLiteral)new TypeLiteral<Map<String, ByteSource>>(){}).toInstance(this.backing);
        } else {
            this.bind((TypeLiteral)new TypeLiteral<Map<String, ByteSource>>(){}).toInstance(BACKING);
        }
    }

    @Provides
    @Singleton
    protected Map<String, Credentials> provideCredentialStore(Map<String, ByteSource> backing, Function<Credentials, ByteSource> credentialsSerializer, Function<ByteSource, Credentials> credentialsDeserializer) {
        return new TransformingMap<String, ByteSource, Credentials>(backing, credentialsDeserializer, credentialsSerializer);
    }

    @Singleton
    public static class CredentialsFromJsonByteSource
    implements Function<ByteSource, Credentials> {
        @Resource
        protected Logger logger = Logger.NULL;
        private final Json json;

        @Inject
        CredentialsFromJsonByteSource(Json json) {
            this.json = json;
        }

        public Credentials apply(ByteSource from) {
            try {
                String creds = ((ByteSource)Preconditions.checkNotNull((Object)from)).asCharSource(Charsets.UTF_8).read();
                if (creds.indexOf("\"user\":") == -1) {
                    return this.json.fromJson(creds, Credentials.class);
                }
                JsonLoginCredentials val = this.json.fromJson(creds, JsonLoginCredentials.class);
                return LoginCredentials.builder().user(val.user).password(val.password).privateKey(val.privateKey).authenticateSudo(Boolean.TRUE.equals(val.authenticateSudo)).build();
            }
            catch (Exception e) {
                this.logger.warn(e, "ignoring problem retrieving credentials", new Object[0]);
                return null;
            }
        }
    }

    static class JsonLoginCredentials {
        private String user;
        private String password;
        private String privateKey;
        private Boolean authenticateSudo;

        JsonLoginCredentials() {
        }
    }

    @Singleton
    public static class CredentialsToJsonByteSource
    implements Function<Credentials, ByteSource> {
        private final Json json;

        @Inject
        CredentialsToJsonByteSource(Json json) {
            this.json = json;
        }

        public ByteSource apply(Credentials from) {
            Preconditions.checkNotNull((Object)from, (Object)"inputCredentials");
            if (from instanceof LoginCredentials) {
                LoginCredentials login = (LoginCredentials)LoginCredentials.class.cast(from);
                JsonLoginCredentials val = new JsonLoginCredentials();
                val.user = login.getUser();
                val.password = (String)login.getOptionalPassword().orNull();
                val.privateKey = (String)login.getOptionalPrivateKey().orNull();
                if (login.shouldAuthenticateSudo()) {
                    val.authenticateSudo = login.shouldAuthenticateSudo();
                }
                return ByteSource.wrap((byte[])this.json.toJson(val).getBytes(Charsets.UTF_8));
            }
            return ByteSource.wrap((byte[])this.json.toJson(from).getBytes(Charsets.UTF_8));
        }
    }
}

