/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import org.jclouds.rest.config.AnnotatedHttpApiProvider;
import org.jclouds.rest.config.AnnotatedSyncToAsyncHttpApiProvider;
import org.jclouds.rest.config.CallGetOnFuturesProvider;
import org.jclouds.rest.config.SyncToAsyncHttpApiProvider;

public class BinderUtils {
    public static <S, A> void bindHttpApi(Binder binder, Class<A> api) {
        BinderUtils.bindClass(binder, api);
        BinderUtils.bindAnnotatedHttpApiProvider(binder, api);
    }

    private static <T> void bindAnnotatedHttpApiProvider(Binder binder, Class<T> annotated) {
        TypeToken token = new TypeToken<AnnotatedHttpApiProvider<T>>(){}.where(new TypeParameter<T>(){}, annotated);
        binder.bind(annotated).toProvider((TypeLiteral)TypeLiteral.class.cast(TypeLiteral.get((Type)token.getType())));
    }

    @Deprecated
    public static <S, A> void bindSyncToAsyncHttpApi(Binder binder, Class<S> sync, Class<A> async) {
        BinderUtils.bindClass(binder, sync);
        BinderUtils.bindClass(binder, async);
        BinderUtils.bindAnnotatedSyncToAsyncHttpApiProvider(binder, async);
        BinderUtils.bindHttpApiProvider(binder, sync, async);
    }

    @Deprecated
    private static <T> void bindAnnotatedSyncToAsyncHttpApiProvider(Binder binder, Class<T> annotated) {
        TypeToken token = new TypeToken<AnnotatedSyncToAsyncHttpApiProvider<T>>(){}.where(new TypeParameter<T>(){}, annotated);
        binder.bind(annotated).toProvider((TypeLiteral)TypeLiteral.class.cast(TypeLiteral.get((Type)token.getType())));
    }

    @Deprecated
    private static <S, A> void bindHttpApiProvider(Binder binder, Class<S> sync, Class<A> async) {
        TypeToken token = new TypeToken<SyncToAsyncHttpApiProvider<S, A>>(){}.where(new TypeParameter<S>(){}, sync).where(new TypeParameter<A>(){}, async);
        binder.bind(sync).toProvider((TypeLiteral)TypeLiteral.class.cast(TypeLiteral.get((Type)token.getType())));
    }

    @Deprecated
    public static <S, A> void bindSyncToAsyncApi(Binder binder, Class<S> sync, Class<A> async) {
        BinderUtils.bindClass(binder, sync);
        BinderUtils.bindClass(binder, async);
        BinderUtils.bindCallGetOnFutures(binder, sync, async);
    }

    @Deprecated
    private static <S, A> void bindCallGetOnFutures(Binder binder, Class<S> sync, Class<A> async) {
        TypeToken token = new TypeToken<CallGetOnFuturesProvider<S, A>>(){}.where(new TypeParameter<S>(){}, sync).where(new TypeParameter<A>(){}, async);
        binder.bind(sync).toProvider((TypeLiteral)TypeLiteral.class.cast(TypeLiteral.get((Type)token.getType())));
    }

    private static <K> void bindClass(Binder binder, Class<K> sync) {
        binder.bind((TypeLiteral)TypeLiteral.class.cast(TypeLiteral.get((Type)new TypeToken<Class<K>>(){}.where(new TypeParameter<K>(){}, sync).getType()))).toInstance(sync);
    }
}

