/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.all;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Region;
import org.jclouds.location.suppliers.all.JustProvider;

@Singleton
public class RegionToProviderOrJustProvider
implements Supplier<Set<? extends Location>> {
    private final JustProvider justProvider;
    private final Supplier<Set<String>> regionsSupplier;
    private final Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier;

    @Inject
    public RegionToProviderOrJustProvider(JustProvider justProvider, @Region Supplier<Set<String>> regionsSupplier, @Iso3166 Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier) {
        this.justProvider = (JustProvider)Preconditions.checkNotNull((Object)justProvider, (Object)"justProvider");
        this.regionsSupplier = (Supplier)Preconditions.checkNotNull(regionsSupplier, (Object)"regionsSupplier");
        this.isoCodesByIdSupplier = (Supplier)Preconditions.checkNotNull(isoCodesByIdSupplier, (Object)"isoCodesByIdSupplier");
    }

    public Set<? extends Location> get() {
        ImmutableSet.Builder locations = ImmutableSet.builder();
        Location provider = (Location)Iterables.getOnlyElement((Iterable)this.justProvider.get());
        Set regions = (Set)this.regionsSupplier.get();
        Map isoCodesById = (Map)this.isoCodesByIdSupplier.get();
        if (regions.size() == 0) {
            return locations.add((Object)provider).build();
        }
        for (String region : regions) {
            LocationBuilder builder = new LocationBuilder().scope(LocationScope.REGION).id(region).description(region).parent(provider);
            if (isoCodesById.containsKey(region)) {
                builder.iso3166Codes((Iterable)((Supplier)isoCodesById.get(region)).get());
            }
            locations.add((Object)builder.build());
        }
        return locations.build();
    }
}

