/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.predicates.fromconfig;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.location.predicates.ZoneIdFilter;
import org.jclouds.location.suppliers.fromconfig.ZoneIdsFromConfiguration;

@Singleton
public class AnyOrConfiguredZoneId
implements ZoneIdFilter {
    private ZoneIdsFromConfiguration idsInConfigSupplier;

    @Inject
    protected AnyOrConfiguredZoneId(ZoneIdsFromConfiguration idsInConfigSupplier) {
        this.idsInConfigSupplier = (ZoneIdsFromConfiguration)Preconditions.checkNotNull((Object)idsInConfigSupplier, (Object)"idsInConfigSupplier");
    }

    public boolean apply(String input) {
        Object idsInConfig = this.idsInConfigSupplier.get();
        if (idsInConfig.size() == 0) {
            return true;
        }
        return idsInConfig.contains(input);
    }

    public String toString() {
        return "anyOrConfiguredZoneId(" + this.idsInConfigSupplier + ")";
    }
}

