/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.suppliers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplierTest")
public class MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplierTest {
    @Test
    public void testLoaderNormal() {
        AtomicReference authException = Atomics.newReference();
        Assert.assertEquals((String)((String)new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.SetAndThrowAuthorizationExceptionSupplierBackedLoader(Suppliers.ofInstance((Object)"foo"), authException).load("KEY").get()), (String)"foo");
        Assert.assertEquals(authException.get(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={AuthorizationException.class})
    public void testLoaderThrowsAuthorizationExceptionAndAlsoSetsExceptionType() {
        AtomicReference authException = Atomics.newReference();
        try {
            new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.SetAndThrowAuthorizationExceptionSupplierBackedLoader((Supplier)new Supplier<String>(){

                public String get() {
                    throw new AuthorizationException();
                }
            }, authException).load("KEY");
        }
        finally {
            Assert.assertEquals(((Object)((Object)((AuthorizationException)((Object)authException.get())))).getClass(), AuthorizationException.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={AuthorizationException.class})
    public void testLoaderThrowsAuthorizationExceptionAndAlsoSetsExceptionTypeWhenNested() {
        AtomicReference authException = Atomics.newReference();
        try {
            new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.SetAndThrowAuthorizationExceptionSupplierBackedLoader((Supplier)new Supplier<String>(){

                public String get() {
                    throw new RuntimeException(new ExecutionException(new AuthorizationException()));
                }
            }, authException).load("KEY");
        }
        finally {
            Assert.assertEquals(((Object)((Object)((AuthorizationException)((Object)authException.get())))).getClass(), AuthorizationException.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={AuthorizationException.class})
    public void testLoaderThrowsAuthorizationExceptionAndAlsoSetsExceptionTypeWhenInUncheckedExecutionException() {
        AtomicReference authException = Atomics.newReference();
        try {
            new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.SetAndThrowAuthorizationExceptionSupplierBackedLoader((Supplier)new Supplier<String>(){

                public String get() {
                    throw new UncheckedExecutionException((Throwable)new AuthorizationException());
                }
            }, authException).load("KEY");
        }
        finally {
            Assert.assertEquals(((Object)((Object)((AuthorizationException)((Object)authException.get())))).getClass(), AuthorizationException.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={RuntimeException.class})
    public void testLoaderThrowsOriginalExceptionAndAlsoSetsExceptionTypeWhenNestedAndNotAuthorizationException() {
        AtomicReference authException = Atomics.newReference();
        try {
            new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.SetAndThrowAuthorizationExceptionSupplierBackedLoader((Supplier)new Supplier<String>(){

                public String get() {
                    throw new RuntimeException(new IllegalArgumentException("foo"));
                }
            }, authException).load("KEY");
        }
        finally {
            Assert.assertEquals(((Object)((Object)((AuthorizationException)((Object)authException.get())))).getClass(), RuntimeException.class);
        }
    }
}

