/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Invokable;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.TimeLimiter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.easymock.EasyMock;
import org.jclouds.Fallback;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.config.InvocationConfig;
import org.jclouds.rest.internal.InvokeSyncToAsyncHttpMethod;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true)
public class InvokeMappedHttpMethodTest {
    private Invocation get;
    private Invocation asyncGet;
    private Function<Invocation, Invocation> sync2async;
    private HttpRequest getRequest = HttpRequest.builder().method("GET").endpoint("http://get").build();
    private HttpCommand getCommand = new HttpCommand(this.getRequest);
    private Function<Invocation, HttpRequest> toRequest;
    private Function<HttpRequest, Function<HttpResponse, ?>> transformerForRequest = (Function)Function.class.cast(Functions.constant((Object)Functions.identity()));
    private ListeningExecutorService userThreads = MoreExecutors.sameThreadExecutor();
    private HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload("foo")).build();
    private HttpCommandExecutorService http;
    private TimeLimiter timeLimiter;
    private Fallback fallback;
    private InvocationConfig config;
    private InvokeSyncToAsyncHttpMethod invokeHttpMethod;
    private ListenableFuture<HttpResponse> future;
    private HttpResponse fallbackResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload("bar")).build();

    @BeforeClass
    void setupInvocations() throws SecurityException, NoSuchMethodException {
        this.get = Invocation.create((Invokable)Reflection2.method(ThingApi.class, (String)"get", (Class[])new Class[0]), (List)ImmutableList.of());
        this.asyncGet = Invocation.create((Invokable)Reflection2.method(ThingAsyncApi.class, (String)"get", (Class[])new Class[0]), (List)ImmutableList.of());
        this.sync2async = Functions.forMap((Map)ImmutableMap.of((Object)this.get, (Object)this.asyncGet));
        this.toRequest = Functions.forMap((Map)ImmutableMap.of((Object)this.asyncGet, (Object)this.getRequest));
    }

    @BeforeMethod
    void createMocks() {
        this.http = (HttpCommandExecutorService)EasyMock.createMock(HttpCommandExecutorService.class);
        this.timeLimiter = (TimeLimiter)EasyMock.createMock(TimeLimiter.class);
        this.fallback = (Fallback)EasyMock.createMock(Fallback.class);
        this.config = (InvocationConfig)EasyMock.createMock(InvocationConfig.class);
        this.future = (ListenableFuture)EasyMock.createMock(ListenableFuture.class);
        this.invokeHttpMethod = new InvokeSyncToAsyncHttpMethod(this.sync2async, this.toRequest, this.http, this.transformerForRequest, this.timeLimiter, this.config, this.userThreads);
        EasyMock.expect((Object)this.config.getCommandName(this.asyncGet)).andReturn((Object)"ns:get");
        EasyMock.expect((Object)this.config.getFallback(this.asyncGet)).andReturn((Object)this.fallback);
    }

    @AfterMethod
    void verifyMocks() {
        EasyMock.verify((Object[])new Object[]{this.http, this.timeLimiter, this.fallback, this.config, this.future});
    }

    public void testMethodWithTimeoutRunsTimeLimiter() throws Exception {
        EasyMock.expect((Object)this.config.getTimeoutNanos(this.asyncGet)).andReturn((Object)Optional.of((Object)250000000L));
        InvokeSyncToAsyncHttpMethod invokeSyncToAsyncHttpMethod = this.invokeHttpMethod;
        invokeSyncToAsyncHttpMethod.getClass();
        InvokeSyncToAsyncHttpMethod.InvokeAndTransform invoke = new InvokeSyncToAsyncHttpMethod.InvokeAndTransform(invokeSyncToAsyncHttpMethod, "ns:get", this.getCommand);
        EasyMock.expect((Object)this.timeLimiter.callWithTimeout((Callable)invoke, 250000000L, TimeUnit.NANOSECONDS, true)).andReturn((Object)this.response);
        EasyMock.replay((Object[])new Object[]{this.http, this.timeLimiter, this.fallback, this.config, this.future});
        this.invokeHttpMethod.apply(this.get);
    }

    public void testMethodWithNoTimeoutCallGetDirectly() throws Exception {
        EasyMock.expect((Object)this.config.getTimeoutNanos(this.asyncGet)).andReturn((Object)Optional.absent());
        EasyMock.expect((Object)this.http.invoke(new HttpCommand(this.getRequest))).andReturn((Object)this.response);
        EasyMock.replay((Object[])new Object[]{this.http, this.timeLimiter, this.fallback, this.config, this.future});
        this.invokeHttpMethod.apply(this.get);
    }

    public void testAsyncMethodSubmitsRequest() throws Exception {
        EasyMock.expect((Object)this.http.submit(new HttpCommand(this.getRequest))).andReturn(this.future);
        this.future.addListener((Runnable)EasyMock.anyObject(Runnable.class), (Executor)EasyMock.eq((Object)this.userThreads));
        EasyMock.replay((Object[])new Object[]{this.http, this.timeLimiter, this.fallback, this.config, this.future});
        this.invokeHttpMethod.apply(this.asyncGet);
    }

    public void testDirectCallRunsFallbackCreateOrPropagate() throws Exception {
        IllegalStateException exception = new IllegalStateException();
        EasyMock.expect((Object)this.config.getTimeoutNanos(this.asyncGet)).andReturn((Object)Optional.absent());
        EasyMock.expect((Object)this.http.invoke(new HttpCommand(this.getRequest))).andThrow((Throwable)exception);
        EasyMock.expect((Object)this.fallback.createOrPropagate((Throwable)exception)).andReturn((Object)this.fallbackResponse);
        EasyMock.replay((Object[])new Object[]{this.http, this.timeLimiter, this.fallback, this.config, this.future});
        Assert.assertEquals((Object)this.invokeHttpMethod.apply(this.get), (Object)this.fallbackResponse);
    }

    public void testTimeLimitedRunsFallbackCreateOrPropagate() throws Exception {
        IllegalStateException exception = new IllegalStateException();
        EasyMock.expect((Object)this.config.getTimeoutNanos(this.asyncGet)).andReturn((Object)Optional.of((Object)250000000L));
        InvokeSyncToAsyncHttpMethod invokeSyncToAsyncHttpMethod = this.invokeHttpMethod;
        invokeSyncToAsyncHttpMethod.getClass();
        InvokeSyncToAsyncHttpMethod.InvokeAndTransform invoke = new InvokeSyncToAsyncHttpMethod.InvokeAndTransform(invokeSyncToAsyncHttpMethod, "ns:get", this.getCommand);
        EasyMock.expect((Object)this.timeLimiter.callWithTimeout((Callable)invoke, 250000000L, TimeUnit.NANOSECONDS, true)).andThrow((Throwable)exception);
        EasyMock.expect((Object)this.fallback.createOrPropagate((Throwable)exception)).andReturn((Object)this.fallbackResponse);
        EasyMock.replay((Object[])new Object[]{this.http, this.timeLimiter, this.fallback, this.config, this.future});
        Assert.assertEquals((Object)this.invokeHttpMethod.apply(this.get), (Object)this.fallbackResponse);
    }

    public void testSubmitRunsFallbackCreateOnGet() throws Exception {
        IllegalStateException exception = new IllegalStateException();
        EasyMock.expect((Object)this.http.submit(new HttpCommand(this.getRequest))).andReturn((Object)Futures.immediateFailedFuture((Throwable)exception));
        EasyMock.expect((Object)this.fallback.create((Throwable)exception)).andReturn((Object)Futures.immediateFuture((Object)this.fallbackResponse));
        this.future = (ListenableFuture)EasyMock.createMock(ListenableFuture.class);
        EasyMock.replay((Object[])new Object[]{this.http, this.timeLimiter, this.fallback, this.config, this.future});
        Assert.assertEquals((Object)((ListenableFuture)ListenableFuture.class.cast(this.invokeHttpMethod.apply(this.asyncGet))).get(), (Object)this.fallbackResponse);
    }

    public static interface ThingAsyncApi {
        @Named(value="ns:get")
        public ListenableFuture<HttpResponse> get();
    }

    public static interface ThingApi {
        public HttpResponse get();
    }
}

