/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.functions;

import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.InvocationSuccess;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.SinceApiVersion;
import org.jclouds.rest.functions.ImplicitOptionalConverter;
import org.jclouds.rest.functions.PresentWhenApiVersionLexicographicallyAtOrAfterSinceApiVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class PresentWhenApiVersionLexicographicallyAtOrAfterSinceApiVersionTest {
    public void testPresentWhenSinceApiVersionUnset() {
        ImplicitOptionalConverter fn = this.forApiVersion("2011-07-15");
        Assert.assertEquals((Object)fn.apply((Object)this.getKeyPairApi()), (Object)Optional.of((Object)"present"));
        Assert.assertEquals((Object)fn.apply((Object)this.getFloatingIPApi()), (Object)Optional.of((Object)"present"));
        Assert.assertEquals((Object)fn.apply((Object)this.getVpcApi()), (Object)Optional.of((Object)"present"));
    }

    public void testPresentWhenSinceApiVersionUnsetOrEqualToApiVersion() {
        ImplicitOptionalConverter fn = this.forApiVersion("2011-01-01");
        Assert.assertEquals((Object)fn.apply((Object)this.getKeyPairApi()), (Object)Optional.of((Object)"present"));
        Assert.assertEquals((Object)fn.apply((Object)this.getFloatingIPApi()), (Object)Optional.of((Object)"present"));
        Assert.assertEquals((Object)fn.apply((Object)this.getVpcApi()), (Object)Optional.of((Object)"present"));
    }

    public void testNotPresentWhenSinceApiVersionSetAndGreaterThanApiVersion() throws SecurityException, NoSuchMethodException {
        ImplicitOptionalConverter fn = this.forApiVersion("2006-06-26");
        Assert.assertEquals((Object)fn.apply((Object)this.getKeyPairApi()), (Object)Optional.of((Object)"present"));
        Assert.assertEquals((Object)fn.apply((Object)this.getFloatingIPApi()), (Object)Optional.absent());
        Assert.assertEquals((Object)fn.apply((Object)this.getVpcApi()), (Object)Optional.absent());
    }

    private ImplicitOptionalConverter forApiVersion(String apiVersion) {
        return new PresentWhenApiVersionLexicographicallyAtOrAfterSinceApiVersion(apiVersion);
    }

    public void testLoaderPresentWhenSinceApiVersionUnset() {
        PresentWhenApiVersionLexicographicallyAtOrAfterSinceApiVersion.Loader fn = new PresentWhenApiVersionLexicographicallyAtOrAfterSinceApiVersion.Loader("2011-07-15");
        Assert.assertEquals((Object)fn.load(this.getKeyPairApi()), (Object)Optional.of((Object)"present"));
        Assert.assertEquals((Object)fn.load(this.getFloatingIPApi()), (Object)Optional.of((Object)"present"));
        Assert.assertEquals((Object)fn.load(this.getVpcApi()), (Object)Optional.of((Object)"present"));
    }

    public void testLoaderPresentWhenSinceApiVersionUnsetOrEqualToApiVersion() {
        PresentWhenApiVersionLexicographicallyAtOrAfterSinceApiVersion.Loader fn = new PresentWhenApiVersionLexicographicallyAtOrAfterSinceApiVersion.Loader("2011-01-01");
        Assert.assertEquals((Object)fn.load(this.getKeyPairApi()), (Object)Optional.of((Object)"present"));
        Assert.assertEquals((Object)fn.load(this.getFloatingIPApi()), (Object)Optional.of((Object)"present"));
        Assert.assertEquals((Object)fn.load(this.getVpcApi()), (Object)Optional.of((Object)"present"));
    }

    public void testLoaderNotPresentWhenSinceApiVersionSetAndGreaterThanApiVersion() throws SecurityException, NoSuchMethodException {
        PresentWhenApiVersionLexicographicallyAtOrAfterSinceApiVersion.Loader fn = new PresentWhenApiVersionLexicographicallyAtOrAfterSinceApiVersion.Loader("2006-06-26");
        Assert.assertEquals((Object)fn.load(this.getKeyPairApi()), (Object)Optional.of((Object)"present"));
        Assert.assertEquals((Object)fn.load(this.getFloatingIPApi()), (Object)Optional.absent());
        Assert.assertEquals((Object)fn.load(this.getVpcApi()), (Object)Optional.absent());
    }

    public void testCacheIsFasterWhenNoAnnotationPresent() {
        InvocationSuccess keyPairApi = this.getKeyPairApi();
        ImplicitOptionalConverter fn = this.forApiVersion("2011-07-15");
        Stopwatch watch = Stopwatch.createStarted();
        fn.apply((Object)keyPairApi);
        long first = watch.stop().elapsed(TimeUnit.MICROSECONDS);
        watch.reset().start();
        fn.apply((Object)keyPairApi);
        long cached = watch.stop().elapsed(TimeUnit.MICROSECONDS);
        Assert.assertTrue((cached < first ? 1 : 0) != 0, (String)String.format("cached [%s] should be less than initial [%s]", cached, first));
        Logger.getAnonymousLogger().info("lookup cache saved " + (first - cached) + " microseconds when no annotation present");
    }

    public void testCacheIsFasterWhenAnnotationPresent() {
        InvocationSuccess floatingIpApi = this.getKeyPairApi();
        ImplicitOptionalConverter fn = this.forApiVersion("2011-07-15");
        Stopwatch watch = Stopwatch.createStarted();
        fn.apply((Object)floatingIpApi);
        long first = watch.stop().elapsed(TimeUnit.MICROSECONDS);
        watch.reset().start();
        fn.apply((Object)floatingIpApi);
        long cached = watch.stop().elapsed(TimeUnit.MICROSECONDS);
        Assert.assertTrue((cached < first ? 1 : 0) != 0, (String)String.format("cached [%s] should be less than initial [%s]", cached, first));
        Logger.getAnonymousLogger().info("lookup cache saved " + (first - cached) + " microseconds when annotation present");
    }

    InvocationSuccess getFloatingIPApi() {
        return this.getApi("Tag", TagAsyncApi.class);
    }

    InvocationSuccess getKeyPairApi() {
        return this.getApi("KeyPair", KeyPairAsyncApi.class);
    }

    InvocationSuccess getVpcApi() {
        return this.getApi("Vpc", VpcAsyncApi.class);
    }

    InvocationSuccess getApi(String name, Class<?> target) {
        try {
            return InvocationSuccess.create((Invocation)Invocation.create((Invokable)Reflection2.method(EC2AsyncApi.class, (String)("get" + name + "ApiForRegion"), (Class[])new Class[]{String.class}), (List)ImmutableList.of((Object)"region")), (Object)"present");
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static interface EC2AsyncApi {
        @Delegate
        public Optional<TagAsyncApi> getTagApiForRegion(String var1);

        @Delegate
        public Optional<KeyPairAsyncApi> getKeyPairApiForRegion(String var1);

        @Delegate
        public Optional<VpcAsyncApi> getVpcApiForRegion(String var1);
    }

    @SinceApiVersion(value="2011-01-01")
    static interface VpcAsyncApi {
    }

    @SinceApiVersion(value="2010-08-31")
    static interface TagAsyncApi {
    }

    static interface KeyPairAsyncApi {
    }
}

