/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.binders.BindToStringPayload;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindToStringPayloadTest")
public class BindToStringPayloadTest {
    @Test
    public void testMap() throws SecurityException, NoSuchMethodException {
        BindToStringPayload binder = new BindToStringPayload();
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        request = binder.bindToRequest(request, (Object)ImmutableMap.of((Object)"imageName", (Object)"foo", (Object)"serverId", (Object)"2"));
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"{imageName=foo, serverId=2}");
        Assert.assertEquals((String)request.getPayload().getContentMetadata().getContentType(), (String)"application/unknown");
    }

    @Test
    public void testSomethingNotAMap() throws SecurityException, NoSuchMethodException {
        BindToStringPayload binder = new BindToStringPayload();
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        request = binder.bindToRequest(request, (Object)new File("foo"));
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"foo");
        Assert.assertEquals((String)request.getPayload().getContentMetadata().getContentType(), (String)"application/unknown");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() {
        BindToStringPayload binder = new BindToStringPayload();
        binder.bindToRequest(HttpRequest.builder().method("GET").endpoint("http://momma").build(), null);
    }
}

