/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.binders.BindToJsonPayloadWrappedWith;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindToJsonPayloadWrappedWithTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new GsonModule(), new FactoryModuleBuilder().build(BindToJsonPayloadWrappedWith.Factory.class)});

    @Test
    public void testCorrect() throws SecurityException, NoSuchMethodException {
        BindToJsonPayloadWrappedWith binder = new BindToJsonPayloadWrappedWith((BindToJsonPayload)this.injector.getInstance(BindToJsonPayload.class), "envelope");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        request = binder.bindToRequest(request, (Object)ImmutableMap.of((Object)"imageName", (Object)"foo", (Object)"serverId", (Object)"2"));
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"{\"envelope\":{\"imageName\":\"foo\",\"serverId\":\"2\"}}");
    }

    @Test
    public void testFactoryCorrect() throws SecurityException, NoSuchMethodException {
        BindToJsonPayloadWrappedWith binder = ((BindToJsonPayloadWrappedWith.Factory)this.injector.getInstance(BindToJsonPayloadWrappedWith.Factory.class)).create("envelope");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        request = binder.bindToRequest(request, (Object)ImmutableMap.of((Object)"imageName", (Object)"foo", (Object)"serverId", (Object)"2"));
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"{\"envelope\":{\"imageName\":\"foo\",\"serverId\":\"2\"}}");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() {
        BindToJsonPayloadWrappedWith binder = new BindToJsonPayloadWrappedWith((BindToJsonPayload)this.injector.getInstance(BindToJsonPayload.class), "envelope");
        binder.bindToRequest(HttpRequest.builder().method("GET").endpoint("http://momma").build(), null);
    }
}

