/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import org.jclouds.http.HttpRequest;
import org.jclouds.rest.binders.BindAsHostPrefix;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindAsHostPrefixTest")
public class BindAsHostPrefixIfConfiguredTest {
    public void testPrefixValid() {
        BindAsHostPrefix binder = new BindAsHostPrefix();
        HttpRequest request = binder.bindToRequest(HttpRequest.builder().method("GET").endpoint("https://s3.amazonaws.com").build(), (Object)"bucket");
        Assert.assertEquals((String)request.getRequestLine(), (String)"GET https://bucket.s3.amazonaws.com HTTP/1.1");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testPrefixInvalidHostname() {
        BindAsHostPrefix binder = new BindAsHostPrefix();
        binder.bindToRequest(HttpRequest.builder().method("GET").endpoint("https://s3.amazonaws.com").build(), (Object)"b_ucket");
    }
}

