/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.logging;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.jclouds.logging.BaseLogger;

public class BufferLogger
extends BaseLogger {
    final String category;
    Level level = Level.INFO;
    List<Record> messages = Collections.synchronizedList(new ArrayList());

    public BufferLogger(String category) {
        this.category = category;
    }

    public List<Record> getMessages() {
        return this.messages;
    }

    public Record assertLogContains(String fragment) {
        for (Record r : this.messages) {
            if (r.getMessage() == null || !r.getMessage().contains(fragment)) continue;
            return r;
        }
        throw new AssertionError((Object)("log did not contain expected '" + fragment + "'"));
    }

    public void assertLogDoesntContain(String fragment) {
        for (Record r : this.messages) {
            if (r.getMessage() != null && r.getMessage().contains(fragment)) {
                throw new AssertionError((Object)("log contained unexpected '" + fragment + "'"));
            }
        }
    }

    public Record assertLogContains(Predicate<Record> test) {
        for (Record r : this.messages) {
            if (r.getMessage() == null || !test.apply((Object)r)) continue;
            return r;
        }
        throw new AssertionError((Object)"log did not contain any records satisfying expected predicate");
    }

    public String getCategory() {
        return this.category;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setAllLevelsEnabled() {
        this.level = Level.ALL;
    }

    public void setAllLevelsDisabled() {
        this.level = Level.OFF;
    }

    public boolean isTraceEnabled() {
        return this.level.intValue() <= Level.FINER.intValue();
    }

    public boolean isDebugEnabled() {
        return this.level.intValue() <= Level.FINE.intValue();
    }

    public boolean isInfoEnabled() {
        return this.level.intValue() <= Level.INFO.intValue();
    }

    public boolean isWarnEnabled() {
        return this.level.intValue() <= Level.WARNING.intValue();
    }

    public boolean isErrorEnabled() {
        return this.level.intValue() <= Level.SEVERE.intValue();
    }

    protected void logError(String message, Throwable e) {
        this.getMessages().add(new Record(Level.SEVERE, message, e));
    }

    protected void logError(String message) {
        this.getMessages().add(new Record(Level.SEVERE, message, null));
    }

    protected void logWarn(String message, Throwable e) {
        this.getMessages().add(new Record(Level.WARNING, message, e));
    }

    protected void logWarn(String message) {
        this.getMessages().add(new Record(Level.WARNING, message, null));
    }

    protected void logInfo(String message) {
        this.getMessages().add(new Record(Level.INFO, message, null));
    }

    protected void logDebug(String message) {
        this.getMessages().add(new Record(Level.FINE, message, null));
    }

    protected void logTrace(String message) {
        this.getMessages().add(new Record(Level.FINER, message, null));
    }

    public static class Record {
        Level level;
        String message;
        Throwable trace;

        public Record(Level level, String message, Throwable trace) {
            this.level = level;
            this.message = message;
            this.trace = trace;
        }

        public Level getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getTrace() {
            return this.trace;
        }
    }
}

