/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.predicates.fromconfig;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.jclouds.location.Provider;
import org.jclouds.location.predicates.ZoneIdFilter;
import org.jclouds.location.predicates.fromconfig.AnyOrConfiguredZoneId;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AnyOrConfiguredZoneIdTest")
public class AnyOrConfiguredZoneIdTest {
    @Test
    public void testWithoutConfigAllIdsMatch() {
        ImmutableSet zoneIds = ImmutableSet.of((Object)"us-east-1a", (Object)"us-east-1b");
        ZoneIdFilter filter = (ZoneIdFilter)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(Provider.class).to("aws-ec2");
            }
        }}).getInstance(AnyOrConfiguredZoneId.class);
        Assert.assertEquals((Set)Sets.filter((Set)zoneIds, (Predicate)filter), (Set)ImmutableSet.of((Object)"us-east-1a", (Object)"us-east-1b"));
    }

    @Test
    public void testWithConfigOnlyMatchingIds() {
        ImmutableSet zoneIds = ImmutableSet.of((Object)"us-east-1a", (Object)"us-east-1b");
        ZoneIdFilter filter = (ZoneIdFilter)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(Provider.class).to("aws-ec2");
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.zones")).to("us-east-1a,us-east-1d");
            }
        }}).getInstance(AnyOrConfiguredZoneId.class);
        Assert.assertEquals((Set)Sets.filter((Set)zoneIds, (Predicate)filter), (Set)ImmutableSet.of((Object)"us-east-1a"));
    }
}

