/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.providers.JcloudsTestBlobStoreProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.internal.BaseRestClientExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="IntegrationTestClientExpectTest")
public class IntegrationTestClientExpectTest
extends BaseRestClientExpectTest<IntegrationTestClient> {
    public void testRetryOnSSLExceptionClose() {
        final AtomicInteger counter = new AtomicInteger(0);
        IntegrationTestClient client = (IntegrationTestClient)this.createClient(new Function<HttpRequest, HttpResponse>(){

            public HttpResponse apply(HttpRequest input) {
                if (counter.getAndIncrement() == 0) {
                    throw Throwables.propagate((Throwable)new SSLException("Received close_notify during handshake"));
                }
                Assert.assertEquals((String)IntegrationTestClientExpectTest.this.renderRequest(input), (String)IntegrationTestClientExpectTest.this.renderRequest(HttpRequest.builder().method("HEAD").endpoint(URI.create("http://mock/objects/rabbit")).build()));
                return HttpResponse.builder().statusCode(200).build();
            }
        });
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((boolean)client.exists("rabbit"), (boolean)true);
        }
        Assert.assertEquals((int)counter.get(), (int)4);
    }

    public void testWhenResponseIs2xxExistsReturnsTrue() {
        IntegrationTestClient client = (IntegrationTestClient)this.requestSendsResponse(HttpRequest.builder().method("HEAD").endpoint(URI.create("http://mock/objects/rabbit")).build(), HttpResponse.builder().statusCode(200).build());
        Assert.assertEquals((boolean)client.exists("rabbit"), (boolean)true);
    }

    public void testWhenResponseIs404ExistsReturnsFalse() {
        IntegrationTestClient client = (IntegrationTestClient)this.requestSendsResponse(HttpRequest.builder().method("HEAD").endpoint(URI.create("http://mock/objects/rabbit")).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((boolean)client.exists("rabbit"), (boolean)false);
    }

    @Override
    public ProviderMetadata createProviderMetadata() {
        return new JcloudsTestBlobStoreProviderMetadata();
    }
}

