/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.functions;

import com.google.common.collect.ImmutableList;
import org.jclouds.functions.JoinOnComma;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true)
public class JoinOnCommaTest {
    @Test
    public void testIterableLong() {
        String list = new JoinOnComma().apply((Object)ImmutableList.of((Object)1L, (Object)2L));
        Assert.assertEquals((String)list, (String)"1,2");
    }

    @Test
    public void testLongArray() {
        String list = new JoinOnComma().apply((Object)new long[]{1L, 2L});
        Assert.assertEquals((String)list, (String)"1,2");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testEmptyArrayIllegalArgumentException() {
        new JoinOnComma().apply((Object)new long[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testEmptyIterableIllegalArgumentException() {
        new JoinOnComma().apply((Object)ImmutableList.of());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullPointer() {
        new JoinOnComma().apply(null);
    }
}

