/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.events.config;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.events.config.EventBusModule;
import org.jclouds.events.config.annotations.AsyncBus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="EventBusModuleTest")
public class EventBusModuleTest {
    private Injector injector;

    @BeforeClass
    public void setup() {
        ExecutorServiceModule userExecutorModule = new ExecutorServiceModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.io-worker-threads")).to(1);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.user-threads")).to(1);
                super.configure();
            }
        };
        EventBusModule eventBusModule = new EventBusModule();
        this.injector = Guice.createInjector((Module[])new Module[]{userExecutorModule, eventBusModule});
    }

    public void testAsyncExecutorIsProvided() {
        Assert.assertNotNull((Object)this.injector.getInstance(AsyncEventBus.class));
    }

    public void testAsyncAnnotatedEventBusIsBound() {
        Key eventBusKey = Key.get(EventBus.class, AsyncBus.class);
        EventBus eventBus = (EventBus)this.injector.getInstance(eventBusKey);
        Assert.assertNotNull((Object)eventBus);
        Assert.assertTrue((boolean)(eventBus instanceof AsyncEventBus));
    }

    public void testEventBusIsSingleton() {
        EventBus eventBus1 = (EventBus)this.injector.getInstance(EventBus.class);
        EventBus eventBus2 = (EventBus)this.injector.getInstance(EventBus.class);
        Assert.assertSame((Object)eventBus1, (Object)eventBus2);
    }
}

