/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect.internal;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.Invokable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.collect.internal.ArgsToPagedIterable;
import org.jclouds.http.HttpRequest;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="ArgsToPagedIterableTest")
public class ArgsToPagedIterableTest {
    @Test
    public void testWhenNextMarkerAbsentDoesntAdvance() {
        GeneratedHttpRequest request = this.args((ImmutableList<Object>)ImmutableList.of());
        TestArgs converter = new TestArgs(request){

            protected Function<Object, IterableWithMarker<String>> markerToNextForArgs(List<Object> args) {
                Assert.fail((String)"The Iterable should not advance");
                return null;
            }
        };
        Assert.assertEquals((Set)converter.apply(IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar"))).concat().toSet(), (Set)ImmutableSet.of((Object)"foo", (Object)"bar"));
    }

    @Test
    public void testWhenNextMarkerPresentButNoArgsMarkerToNextForArgsParamIsAbsent() {
        GeneratedHttpRequest request = this.args((ImmutableList<Object>)ImmutableList.of());
        final IterableWithMarker next = IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"baz"));
        TestArgs converter = new TestArgs(request){

            protected Function<Object, IterableWithMarker<String>> markerToNextForArgs(List<Object> args) {
                Assert.assertTrue((boolean)args.isEmpty());
                return Functions.constant((Object)next);
            }
        };
        Assert.assertEquals((Set)converter.apply(IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)"marker")).concat().toSet(), (Set)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"baz"));
    }

    @Test
    public void testWhenNextMarkerPresentWithArgsMarkerToNextForArgsParamIsPresent() {
        GeneratedHttpRequest request = this.args((ImmutableList<Object>)ImmutableList.of((Object)"path"));
        final IterableWithMarker next = IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"baz"));
        TestArgs converter = new TestArgs(request){

            protected Function<Object, IterableWithMarker<String>> markerToNextForArgs(List<Object> args) {
                Assert.assertEquals((Object)args.get(0), (Object)"path");
                return Functions.constant((Object)next);
            }
        };
        Assert.assertEquals((Set)converter.apply(IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)"marker")).concat().toSet(), (Set)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"baz"));
    }

    private GeneratedHttpRequest args(ImmutableList<Object> args) {
        try {
            return ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().method("GET")).endpoint("http://localhost")).invocation(Invocation.create((Invokable)Invokable.from((Method)String.class.getMethod("toString", new Class[0])), args)).build();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Test
    public void testFromCallerWhenNextMarkerPresentButNoArgsMarkerToNextForArgsParamIsAbsent() {
        GeneratedHttpRequest request = this.callerArgs((ImmutableList<Object>)ImmutableList.of());
        final IterableWithMarker next = IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"baz"));
        TestCallerArgs converter = new TestCallerArgs(request){

            protected Function<Object, IterableWithMarker<String>> markerToNextForArgs(List<Object> args) {
                Assert.assertTrue((boolean)args.isEmpty());
                return Functions.constant((Object)next);
            }
        };
        Assert.assertEquals((Set)converter.apply(IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)"marker")).concat().toSet(), (Set)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"baz"));
    }

    @Test
    public void testFromCallerWhenNextMarkerPresentWithArgsMarkerToNextForArgsParamIsPresent() {
        GeneratedHttpRequest request = this.callerArgs((ImmutableList<Object>)ImmutableList.of((Object)"path"));
        final IterableWithMarker next = IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"baz"));
        TestCallerArgs converter = new TestCallerArgs(request){

            protected Function<Object, IterableWithMarker<String>> markerToNextForArgs(List<Object> args) {
                Assert.assertEquals((Object)args.get(0), (Object)"path");
                return Functions.constant((Object)next);
            }
        };
        Assert.assertEquals((Set)converter.apply(IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)"marker")).concat().toSet(), (Set)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"baz"));
    }

    private GeneratedHttpRequest callerArgs(ImmutableList<Object> args) {
        try {
            return ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().method("GET")).endpoint("http://localhost")).invocation(Invocation.create((Invokable)Invokable.from((Method)String.class.getMethod("toString", new Class[0])))).caller(Invocation.create((Invokable)Invokable.from((Method)String.class.getMethod("toString", new Class[0])), args)).build();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static abstract class TestCallerArgs
    extends ArgsToPagedIterable.FromCaller<String, TestCallerArgs> {
        private TestCallerArgs(GeneratedHttpRequest in) {
            this.setContext((HttpRequest)in);
        }
    }

    private static abstract class TestArgs
    extends ArgsToPagedIterable<String, TestArgs> {
        private TestArgs(GeneratedHttpRequest in) {
            this.setContext((HttpRequest)in);
        }
    }
}

