/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.util;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.net.URI;
import java.util.List;
import org.easymock.EasyMock;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BlobStoreUtilsTest {
    public void testCreateParentIfNeededAsyncNoPath() {
        AsyncBlobStore asyncBlobStore = (AsyncBlobStore)EasyMock.createMock(AsyncBlobStore.class);
        String container = "container";
        Blob blob = (Blob)EasyMock.createMock(Blob.class);
        MutableBlobMetadata md = (MutableBlobMetadata)EasyMock.createMock(MutableBlobMetadata.class);
        EasyMock.expect((Object)blob.getMetadata()).andReturn((Object)md).atLeastOnce();
        EasyMock.expect((Object)md.getName()).andReturn((Object)"hello").atLeastOnce();
        EasyMock.replay((Object[])new Object[]{asyncBlobStore});
        EasyMock.replay((Object[])new Object[]{blob});
        EasyMock.replay((Object[])new Object[]{md});
        BlobStoreUtils.createParentIfNeededAsync((AsyncBlobStore)asyncBlobStore, (String)container, (Blob)blob);
        EasyMock.verify((Object[])new Object[]{asyncBlobStore});
        EasyMock.verify((Object[])new Object[]{blob});
        EasyMock.verify((Object[])new Object[]{md});
    }

    public void testCreateParentIfNeededAsyncSinglePath() {
        AsyncBlobStore asyncBlobStore = (AsyncBlobStore)EasyMock.createMock(AsyncBlobStore.class);
        String container = "container";
        Blob blob = (Blob)EasyMock.createMock(Blob.class);
        MutableBlobMetadata md = (MutableBlobMetadata)EasyMock.createMock(MutableBlobMetadata.class);
        EasyMock.expect((Object)blob.getMetadata()).andReturn((Object)md).atLeastOnce();
        EasyMock.expect((Object)md.getName()).andReturn((Object)"rootpath/hello").atLeastOnce();
        EasyMock.expect((Object)asyncBlobStore.createDirectory("container", "rootpath")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{asyncBlobStore});
        EasyMock.replay((Object[])new Object[]{blob});
        EasyMock.replay((Object[])new Object[]{md});
        BlobStoreUtils.createParentIfNeededAsync((AsyncBlobStore)asyncBlobStore, (String)container, (Blob)blob);
        EasyMock.verify((Object[])new Object[]{asyncBlobStore});
        EasyMock.verify((Object[])new Object[]{blob});
        EasyMock.verify((Object[])new Object[]{md});
    }

    public void testCreateParentIfNeededAsyncNestedPath() {
        AsyncBlobStore asyncBlobStore = (AsyncBlobStore)EasyMock.createMock(AsyncBlobStore.class);
        String container = "container";
        Blob blob = (Blob)EasyMock.createMock(Blob.class);
        MutableBlobMetadata md = (MutableBlobMetadata)EasyMock.createMock(MutableBlobMetadata.class);
        EasyMock.expect((Object)blob.getMetadata()).andReturn((Object)md).atLeastOnce();
        EasyMock.expect((Object)md.getName()).andReturn((Object)"rootpath/subpath/hello").atLeastOnce();
        EasyMock.expect((Object)asyncBlobStore.createDirectory("container", "rootpath/subpath")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{asyncBlobStore});
        EasyMock.replay((Object[])new Object[]{blob});
        EasyMock.replay((Object[])new Object[]{md});
        BlobStoreUtils.createParentIfNeededAsync((AsyncBlobStore)asyncBlobStore, (String)container, (Blob)blob);
        EasyMock.verify((Object[])new Object[]{asyncBlobStore});
        EasyMock.verify((Object[])new Object[]{blob});
        EasyMock.verify((Object[])new Object[]{md});
    }

    public void testGetKeyForAzureS3AndRackspace() {
        GeneratedHttpRequest request = this.requestForEndpointAndArgs("https://jclouds.blob.core.windows.net/adriancole-blobstore0/five", (List<Object>)ImmutableList.of((Object)"adriancole-blobstore0", (Object)"five"));
        Assert.assertEquals((String)BlobStoreUtils.getNameFor((GeneratedHttpRequest)request), (String)"five");
    }

    public void testGetKeyForAtmos() {
        GeneratedHttpRequest request = this.requestForEndpointAndArgs("https://storage4.clouddrive.com/v1/MossoCloudFS_dc1f419c-5059-4c87-a389-3f2e33a77b22/adriancole-blobstore0/four", (List<Object>)ImmutableList.of((Object)"adriancole-blobstore0/four"));
        Assert.assertEquals((String)BlobStoreUtils.getNameFor((GeneratedHttpRequest)request), (String)"four");
    }

    GeneratedHttpRequest requestForEndpointAndArgs(String endpoint, List<Object> args) {
        try {
            Invocation invocation = Invocation.create((Invokable)Reflection2.method(String.class, (String)"toString", (Class[])new Class[0]), args);
            return ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().method("POST")).endpoint(URI.create(endpoint))).invocation(invocation).build();
        }
        catch (SecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

