/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import org.jclouds.blobstore.options.GetOptions;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class GetOptionsTest {
    private String etag;
    private Date now;

    @BeforeTest
    void setUp() {
        this.now = new Date();
        this.etag = "yrdy";
    }

    @Test
    public void testIfModifiedSince() {
        GetOptions options = new GetOptions();
        options.ifModifiedSince(this.now);
        Assert.assertEquals((Object)options.getIfModifiedSince(), (Object)this.now);
    }

    @Test
    public void testNullIfModifiedSince() {
        GetOptions options = new GetOptions();
        Assert.assertNull((Object)options.getIfModifiedSince());
    }

    @Test
    public void testIfModifiedSinceStatic() {
        GetOptions options = GetOptions.Builder.ifModifiedSince((Date)this.now);
        Assert.assertEquals((Object)options.getIfModifiedSince(), (Object)this.now);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testIfModifiedSinceNPE() {
        GetOptions.Builder.ifModifiedSince(null);
    }

    @Test
    public void testIfUnmodifiedSince() {
        GetOptions options = new GetOptions();
        options.ifUnmodifiedSince(this.now);
        this.isNowExpected(options);
    }

    @Test
    public void testNullIfUnmodifiedSince() {
        GetOptions options = new GetOptions();
        Assert.assertNull((Object)options.getIfUnmodifiedSince());
    }

    @Test
    public void testIfUnmodifiedSinceStatic() {
        GetOptions options = GetOptions.Builder.ifUnmodifiedSince((Date)this.now);
        this.isNowExpected(options);
    }

    private void isNowExpected(GetOptions options) {
        Assert.assertEquals((Object)options.getIfUnmodifiedSince(), (Object)this.now);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testIfUnmodifiedSinceNPE() {
        GetOptions.Builder.ifUnmodifiedSince(null);
    }

    public void testModifiedSinceAndRange() {
        GetOptions options = new GetOptions();
        options.ifModifiedSince(this.now);
        options.range(0L, 1024L);
        Assert.assertEquals((Object)options.getIfModifiedSince(), (Object)this.now);
        this.bytes1to1024(options);
    }

    @Test
    public void testRange() {
        GetOptions options = new GetOptions();
        options.range(0L, 1024L);
        this.bytes1to1024(options);
    }

    private void bytes1to1024(GetOptions options) {
        Assert.assertEquals((String)((String)options.getRanges().get(0)), (String)"0-1024");
    }

    @Test
    public void testRangeZeroToFive() {
        GetOptions options = new GetOptions();
        options.range(0L, 5L);
        Assert.assertEquals((String)((String)options.getRanges().get(0)), (String)"0-5");
    }

    @Test
    public void testRangeZeroToFiveAnd10through100() {
        GetOptions options = new GetOptions();
        options.range(0L, 5L).range(10L, 100L);
        Assert.assertEquals((Collection)options.getRanges(), (Collection)ImmutableList.of((Object)"0-5", (Object)"10-100"));
    }

    @Test
    public void testRangeStartAt() {
        GetOptions options = new GetOptions();
        options.startAt(5L);
        Assert.assertEquals((Collection)options.getRanges(), (Collection)ImmutableList.of((Object)"5-"));
    }

    @Test
    public void testRangeTail() {
        GetOptions options = new GetOptions();
        options.tail(5L);
        Assert.assertEquals((Collection)options.getRanges(), (Collection)ImmutableList.of((Object)"-5"));
    }

    @Test
    public void testNoRange() {
        GetOptions options = new GetOptions();
        Assert.assertEquals((int)options.getRanges().size(), (int)0);
    }

    @Test
    public void testRangeStatic() {
        GetOptions options = GetOptions.Builder.range((long)0L, (long)1024L);
        this.bytes1to1024(options);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testRangeNegative1() {
        GetOptions.Builder.range((long)-1L, (long)0L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testRangeNegative2() {
        GetOptions.Builder.range((long)0L, (long)-1L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testRangeNegative() {
        GetOptions.Builder.range((long)-1L, (long)-1L);
    }

    @Test
    public void testIfETagMatches() {
        GetOptions options = new GetOptions();
        options.ifETagMatches(this.etag);
        Assert.assertEquals((String)this.etag, (String)options.getIfMatch());
    }

    @Test
    public void testNullIfETagMatches() {
        GetOptions options = new GetOptions();
        Assert.assertNull((Object)options.getIfMatch());
    }

    @Test
    public void testIfETagMatchesStatic() {
        GetOptions options = GetOptions.Builder.ifETagMatches((String)this.etag);
        Assert.assertEquals((String)this.etag, (String)options.getIfMatch());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testIfETagMatchesNPE() {
        GetOptions.Builder.ifETagMatches(null);
    }

    @Test
    public void testIfETagDoesntMatch() {
        GetOptions options = new GetOptions();
        options.ifETagDoesntMatch(this.etag);
        Assert.assertEquals((String)this.etag, (String)options.getIfNoneMatch());
    }

    @Test
    public void testNullIfETagDoesntMatch() {
        GetOptions options = new GetOptions();
        Assert.assertNull((Object)options.getIfNoneMatch());
    }

    @Test
    public void testIfETagDoesntMatchStatic() {
        GetOptions options = GetOptions.Builder.ifETagDoesntMatch((String)this.etag);
        Assert.assertEquals((String)this.etag, (String)options.getIfNoneMatch());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testIfETagDoesntMatchNPE() {
        GetOptions.Builder.ifETagDoesntMatch(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIfUnmodifiedAfterModified() {
        GetOptions.Builder.ifModifiedSince((Date)this.now).ifUnmodifiedSince(this.now);
    }

    public void testIfUnmodifiedAfterETagMatches() {
        GetOptions.Builder.ifETagMatches((String)this.etag).ifUnmodifiedSince(this.now);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIfUnmodifiedAfterETagDoesntMatch() {
        GetOptions.Builder.ifETagDoesntMatch((String)this.etag).ifUnmodifiedSince(this.now);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIfModifiedAfterUnmodified() {
        GetOptions.Builder.ifUnmodifiedSince((Date)this.now).ifModifiedSince(this.now);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIfModifiedAfterETagMatches() {
        GetOptions.Builder.ifETagMatches((String)this.etag).ifModifiedSince(this.now);
    }

    public void testIfModifiedAfterETagDoesntMatch() {
        GetOptions.Builder.ifETagDoesntMatch((String)this.etag).ifModifiedSince(this.now);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testETagMatchesAfterIfModified() {
        GetOptions.Builder.ifModifiedSince((Date)this.now).ifETagMatches(this.etag);
    }

    public void testETagMatchesAfterIfUnmodified() {
        GetOptions.Builder.ifUnmodifiedSince((Date)this.now).ifETagMatches(this.etag);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testETagMatchesAfterETagDoesntMatch() {
        GetOptions.Builder.ifETagDoesntMatch((String)this.etag).ifETagMatches(this.etag);
    }

    public void testETagDoesntMatchAfterIfModified() {
        GetOptions.Builder.ifModifiedSince((Date)this.now).ifETagDoesntMatch(this.etag);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testETagDoesntMatchAfterIfUnmodified() {
        GetOptions.Builder.ifUnmodifiedSince((Date)this.now).ifETagDoesntMatch(this.etag);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testETagDoesntMatchAfterETagMatches() {
        GetOptions.Builder.ifETagMatches((String)this.etag).ifETagDoesntMatch(this.etag);
    }
}

