/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BaseContainerIntegrationTest
extends BaseBlobStoreIntegrationTest {
    @Test(groups={"integration", "live"})
    public void containerDoesntExist() {
        assert (!((BlobStoreContext)this.view).getBlobStore().containerExists("forgetaboutit"));
        assert (!((BlobStoreContext)this.view).getBlobStore().containerExists("cloudcachestorefunctionalintegrationtest-first"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutTwiceIsOkAndDoesntOverwrite() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            ((BlobStoreContext)this.view).getBlobStore().createContainerInLocation(null, containerName);
            Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder("hello").payload(TEST_STRING).build();
            ((BlobStoreContext)this.view).getBlobStore().putBlob(containerName, blob);
            ((BlobStoreContext)this.view).getBlobStore().createContainerInLocation(null, containerName);
            Assert.assertEquals((long)((BlobStoreContext)this.view).getBlobStore().countBlobs(containerName), (long)1L);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testWithDetails() throws InterruptedException, IOException {
        String key = "hello";
        String containerName = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, ((BlobStoreContext)this.view).getBlobStore().blobBuilder(key).userMetadata((Map)ImmutableMap.of((Object)"Adrian", (Object)"powderpuff")).payload(TEST_STRING).contentType("text/plain").contentMD5(Hashing.md5().hashString((CharSequence)TEST_STRING, Charsets.UTF_8).asBytes()).build());
            this.validateContent(containerName, key);
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.maxResults((int)1).withDetails());
            BlobMetadata metadata = (BlobMetadata)BlobMetadata.class.cast(Iterables.get((Iterable)container, (int)0));
            assert (metadata.getContentMetadata().getContentType().startsWith("text/plain")) : metadata.getContentMetadata().getContentType();
            Assert.assertEquals((Object)metadata.getContentMetadata().getContentLength(), (Object)TEST_STRING.length());
            Assert.assertEquals((String)((String)metadata.getUserMetadata().get("adrian")), (String)"powderpuff");
            this.checkMD5(metadata);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    protected void checkMD5(BlobMetadata metadata) throws IOException {
        Assert.assertEquals((byte[])metadata.getContentMetadata().getContentMD5(), (byte[])Hashing.md5().hashString((CharSequence)TEST_STRING, Charsets.UTF_8).asBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testClearWhenContentsUnderPath() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            this.add5BlobsUnderPathAnd5UnderRootToContainer(containerName);
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName);
            this.assertConsistencyAwareContainerSize(containerName, 0);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testListContainerMarker() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            this.addAlphabetUnderRoot(containerName);
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.maxResults((int)1));
            assert (container.getNextMarker() != null);
            Assert.assertEquals((int)container.size(), (int)1);
            String marker = container.getNextMarker();
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.afterMarker((String)marker));
            Assert.assertEquals((String)container.getNextMarker(), null);
            assert (container.size() == 25) : String.format("size should have been 25, but was %d: %s", container.size(), container);
            assert (container.getNextMarker() == null);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testListRootUsesDelimiter() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            String prefix = "rootdelimiter";
            this.addTenObjectsUnderPrefix(containerName, prefix);
            this.add15UnderRoot(containerName);
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName);
            assert (container.getNextMarker() == null);
            Assert.assertEquals((int)container.size(), (int)16);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testDirectory() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            String directory = "directory";
            assert (!((BlobStoreContext)this.view).getBlobStore().directoryExists(containerName, directory));
            ((BlobStoreContext)this.view).getBlobStore().createDirectory(containerName, directory);
            assert (((BlobStoreContext)this.view).getBlobStore().directoryExists(containerName, directory));
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName);
            assert (container.getNextMarker() == null);
            assert (container.size() == 1) : container;
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.inDirectory((String)directory));
            assert (container.getNextMarker() == null);
            assert (container.size() == 0) : container;
            this.addTenObjectsUnderPrefix(containerName, directory);
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName);
            assert (container.getNextMarker() == null);
            assert (container.size() == 1) : container;
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.inDirectory((String)directory));
            assert (container.getNextMarker() == null);
            assert (container.size() == 10) : container;
            assert (!((BlobStoreContext)this.view).getBlobStore().directoryExists(containerName, directory + "/" + directory));
            ((BlobStoreContext)this.view).getBlobStore().createDirectory(containerName, directory + "/" + directory);
            assert (((BlobStoreContext)this.view).getBlobStore().directoryExists(containerName, directory + "/" + directory));
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName, ListContainerOptions.Builder.inDirectory((String)directory));
            assert (((BlobStoreContext)this.view).getBlobStore().directoryExists(containerName, directory));
            assert (((BlobStoreContext)this.view).getBlobStore().directoryExists(containerName, directory + "/" + directory));
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.inDirectory((String)directory));
            assert (container.getNextMarker() == null);
            assert (container.size() == 1) : container;
            ((BlobStoreContext)this.view).getBlobStore().createDirectory(containerName, directory + "/" + directory);
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.inDirectory((String)directory).recursive());
            assert (container.getNextMarker() == null);
            assert (container.size() == 1) : container;
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName, ListContainerOptions.Builder.inDirectory((String)directory).recursive());
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.inDirectory((String)directory));
            assert (container.getNextMarker() == null);
            assert (container.size() == 0) : container;
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName);
            assert (container.getNextMarker() == null);
            assert (container.size() == 1) : container;
            ((BlobStoreContext)this.view).getBlobStore().deleteDirectory(containerName, directory);
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName);
            assert (container.getNextMarker() == null);
            assert (container.size() == 0) : container;
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testListContainerPrefix() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            String prefix = "containerprefix";
            this.addTenObjectsUnderPrefix(containerName, prefix);
            this.add15UnderRoot(containerName);
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.inDirectory((String)prefix));
            assert (container.getNextMarker() == null);
            Assert.assertEquals((int)container.size(), (int)10);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testListContainerMaxResults() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            this.addAlphabetUnderRoot(containerName);
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.maxResults((int)5));
            Assert.assertEquals((int)container.size(), (int)5);
            assert (container.getNextMarker() != null);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void containerExists() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            assert (((BlobStoreContext)this.view).getBlobStore().containerExists(containerName));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void deleteContainerWithContents() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, "test");
            ((BlobStoreContext)this.view).getBlobStore().deleteContainer(containerName);
            this.assertNotExists(containerName);
        }
        finally {
            this.recycleContainerAndAddToPool(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void deleteContainerWithoutContents() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            ((BlobStoreContext)this.view).getBlobStore().deleteContainer(containerName);
            this.assertNotExists(containerName);
        }
        finally {
            this.recycleContainerAndAddToPool(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void deleteContainerIfEmptyWithContents() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, "test");
            Assert.assertFalse((boolean)((BlobStoreContext)this.view).getBlobStore().deleteContainerIfEmpty(containerName));
            Assert.assertTrue((boolean)((BlobStoreContext)this.view).getBlobStore().containerExists(containerName));
        }
        finally {
            this.recycleContainerAndAddToPool(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void deleteContainerIfEmptyWithoutContents() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            Assert.assertTrue((boolean)((BlobStoreContext)this.view).getBlobStore().deleteContainerIfEmpty(containerName));
            this.assertNotExists(containerName);
            Assert.assertTrue((boolean)((BlobStoreContext)this.view).getBlobStore().deleteContainerIfEmpty(containerName));
        }
        finally {
            this.recycleContainerAndAddToPool(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testListContainer() throws InterruptedException, ExecutionException, TimeoutException {
        String containerName = this.getContainerName();
        try {
            this.add15UnderRoot(containerName);
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName);
            Assert.assertEquals((int)container.size(), (int)15);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    protected void addAlphabetUnderRoot(String containerName) throws InterruptedException {
        for (char letter = 'a'; letter <= 'z'; letter = (char)(letter + '\u0001')) {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(containerName, ((BlobStoreContext)this.view).getBlobStore().blobBuilder(letter + "").payload(letter + "content").build());
        }
        this.assertContainerSize(containerName, 26);
    }

    protected void assertContainerSize(final String containerName, final int size) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                try {
                    Assert.assertEquals((long)((BlobStoreContext)BaseContainerIntegrationTest.this.view).getBlobStore().countBlobs(containerName), (long)size);
                }
                catch (Exception e) {
                    Throwables.propagateIfPossible((Throwable)e);
                }
            }
        });
    }

    protected void add15UnderRoot(String containerName) throws InterruptedException {
        for (int i = 0; i < 15; ++i) {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(containerName, ((BlobStoreContext)this.view).getBlobStore().blobBuilder(i + "").payload(i + "content").build());
        }
    }

    protected void addTenObjectsUnderPrefix(String containerName, String prefix) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(containerName, ((BlobStoreContext)this.view).getBlobStore().blobBuilder(prefix + "/" + i).payload(i + "content").build());
        }
    }
}

