/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class BaseBlobSignerLiveTest
extends BaseBlobStoreIntegrationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignGetUrl() throws Exception {
        String name = "hello";
        String text = "fooooooooooooooooooooooo";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(text).contentType("text/plain").build();
        String container = this.getContainerName();
        try {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob);
            this.assertConsistencyAwareContainerSize(container, 1);
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signGetBlob(container, name);
            Assert.assertEquals((int)request.getFilters().size(), (int)0);
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().invoke(request).getPayload().openStream()), (String)text);
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignGetUrlOptions() throws Exception {
        String name = "hello";
        String text = "fooooooooooooooooooooooo";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(text).contentType("text/plain").build();
        String container = this.getContainerName();
        try {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob);
            this.assertConsistencyAwareContainerSize(container, 1);
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signGetBlob(container, name, GetOptions.Builder.range((long)0L, (long)1L));
            Assert.assertEquals((int)request.getFilters().size(), (int)0);
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().invoke(request).getPayload().openStream()), (String)"fo");
        }
        finally {
            this.returnContainer(container);
        }
    }

    @Test
    public void testSignGetUrlWithTime() throws InterruptedException, IOException {
        String name = "hello";
        String text = "fooooooooooooooooooooooo";
        int timeout = 5;
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(text).contentType("text/plain").build();
        String container = this.getContainerName();
        try {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob);
            this.assertConsistencyAwareContainerSize(container, 1);
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signGetBlob(container, name, (long)timeout);
            Assert.assertEquals((int)request.getFilters().size(), (int)0);
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().invoke(request).getPayload().openStream()), (String)text);
            TimeUnit.SECONDS.sleep(2 * timeout);
            try {
                Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().invoke(request).getPayload().openStream());
                Assert.fail((String)"Temporary URL did not expire as expected");
            }
            catch (AuthorizationException expected) {
                // empty catch block
            }
        }
        catch (UnsupportedOperationException ignore) {
            throw new SkipException("signGetUrl with a time limit is not supported on " + this.provider);
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignPutUrl() throws Exception {
        String name = "hello";
        String text = "fooooooooooooooooooooooo";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(text).contentType("text/plain").build();
        String container = this.getContainerName();
        try {
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signPutBlob(container, blob);
            Assert.assertEquals((int)request.getFilters().size(), (int)0);
            Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().invoke(request).getPayload().openStream());
            this.assertConsistencyAwareContainerSize(container, 1);
        }
        finally {
            this.returnContainer(container);
        }
    }

    @Test
    public void testSignPutUrlWithTime() throws Exception {
        String name = "hello";
        String text = "fooooooooooooooooooooooo";
        int timeout = 5;
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(text).contentType("text/plain").build();
        String container = this.getContainerName();
        try {
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signPutBlob(container, blob, (long)timeout);
            Assert.assertEquals((int)request.getFilters().size(), (int)0);
            request = ((HttpRequest.Builder)request.toBuilder().removeHeader("Expect")).build();
            Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().invoke(request).getPayload().openStream());
            this.assertConsistencyAwareContainerSize(container, 1);
            ((BlobStoreContext)this.view).getBlobStore().removeBlob(container, name);
            this.assertConsistencyAwareContainerSize(container, 0);
            TimeUnit.SECONDS.sleep(2 * timeout);
            try {
                Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().invoke(request).getPayload().openStream());
                Assert.fail((String)"Temporary URL did not expire as expected");
            }
            catch (AuthorizationException expected) {
                // empty catch block
            }
        }
        catch (UnsupportedOperationException ignore) {
            throw new SkipException("signPutUrl with a time limit is not supported on " + this.provider);
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignRemoveUrl() throws Exception {
        String name = "hello";
        String text = "fooooooooooooooooooooooo";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(text).contentType("text/plain").build();
        String container = this.getContainerName();
        try {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob);
            this.assertConsistencyAwareContainerSize(container, 1);
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signRemoveBlob(container, name);
            Assert.assertEquals((int)request.getFilters().size(), (int)0);
            ((BlobStoreContext)this.view).utils().http().invoke(request);
            assert (!((BlobStoreContext)this.view).getBlobStore().blobExists(container, name));
        }
        finally {
            this.returnContainer(container);
        }
    }
}

