/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.crypto.Crypto;
import org.jclouds.encryption.internal.JCECrypto;
import org.jclouds.http.HttpResponseException;
import org.jclouds.io.ByteStreams2;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.io.payloads.FilePayload;
import org.jclouds.logging.Logger;
import org.jclouds.utils.TestUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BaseBlobIntegrationTest
extends BaseBlobStoreIntegrationTest {
    private static final ByteSource oneHundredOneConstitutions = TestUtils.randomByteSource().slice(0L, 4556918L);
    protected static volatile Crypto crypto;

    @Override
    @BeforeClass(groups={"integration", "live"}, dependsOnMethods={"setupContext"})
    public void setUpResourcesOnThisThread(ITestContext testContext) throws Exception {
        super.setUpResourcesOnThisThread(testContext);
    }

    public static ByteSource getTestDataSupplier() throws IOException {
        return oneHundredOneConstitutions;
    }

    public static long getOneHundredOneConstitutionsLength() throws IOException {
        return oneHundredOneConstitutions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutFileParallel() throws InterruptedException, IOException, TimeoutException {
        File payloadFile = File.createTempFile("testPutFileParallel", "png");
        BaseBlobIntegrationTest.createTestInput(32768).copyTo(Files.asByteSink((File)payloadFile, (FileWriteMode[])new FileWriteMode[0]));
        FilePayload testPayload = Payloads.newFilePayload((File)payloadFile);
        HashCode md5 = ByteStreams2.hashAndClose((InputStream)testPayload.openStream(), (HashFunction)Hashing.md5());
        testPayload.getContentMetadata().setContentType("image/png");
        final AtomicInteger blobCount = new AtomicInteger();
        String container = this.getContainerName();
        try {
            HashMap responses = Maps.newHashMap();
            for (int i = 0; i < 3; ++i) {
                responses.put(i, this.exec.submit((Callable)new Callable<Void>((Payload)testPayload, container, md5){
                    final /* synthetic */ Payload val$testPayload;
                    final /* synthetic */ String val$container;
                    final /* synthetic */ HashCode val$md5;
                    {
                        this.val$testPayload = payload;
                        this.val$container = string;
                        this.val$md5 = hashCode;
                    }

                    @Override
                    public Void call() throws Exception {
                        String name = blobCount.incrementAndGet() + "";
                        Blob blob = ((BlobStoreContext)BaseBlobIntegrationTest.this.view).getBlobStore().blobBuilder(name).payload(this.val$testPayload).build();
                        ((BlobStoreContext)BaseBlobIntegrationTest.this.view).getBlobStore().putBlob(this.val$container, blob);
                        BaseBlobIntegrationTest.this.assertConsistencyAwareBlobExists(this.val$container, name);
                        blob = ((BlobStoreContext)BaseBlobIntegrationTest.this.view).getBlobStore().getBlob(this.val$container, name);
                        Assert.assertEquals((Object)ByteStreams2.hashAndClose((InputStream)blob.getPayload().openStream(), (HashFunction)Hashing.md5()), (Object)this.val$md5, (String)String.format("md5 didn't match on %s/%s", this.val$container, name));
                        ((BlobStoreContext)BaseBlobIntegrationTest.this.view).getBlobStore().removeBlob(this.val$container, name);
                        BaseBlobIntegrationTest.this.assertConsistencyAwareBlobDoesntExist(this.val$container, name);
                        return null;
                    }
                }));
            }
            Map exceptions = FutureIterables.awaitCompletion((Map)responses, (ListeningExecutorService)this.exec, (Long)30000L, (Logger)Logger.CONSOLE, (String)"putFileParallel");
            assert (exceptions.size() == 0) : exceptions;
        }
        finally {
            payloadFile.delete();
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testFileGetParallel() throws Exception {
        final ByteSource supplier = BaseBlobIntegrationTest.createTestInput(32768);
        String expectedContentDisposition = "attachment; filename=constit.txt";
        final String container = this.getContainerName();
        try {
            String name = "constitution.txt";
            this.uploadByteSource(container, "constitution.txt", "attachment; filename=constit.txt", supplier);
            HashMap responses = Maps.newHashMap();
            for (int i = 0; i < 10; ++i) {
                responses.put(i, Futures.transform((ListenableFuture)((BlobStoreContext)this.view).getAsyncBlobStore().getBlob(container, "constitution.txt"), (Function)new Function<Blob, Void>(){

                    public Void apply(Blob from) {
                        try {
                            BaseBlobIntegrationTest.this.validateMetadata(from.getMetadata(), container, "constitution.txt");
                            Assert.assertEquals((Object)ByteStreams2.hashAndClose((InputStream)from.getPayload().openStream(), (HashFunction)Hashing.md5()), (Object)supplier.hash(Hashing.md5()));
                            BaseBlobIntegrationTest.this.checkContentDisposition(from, "attachment; filename=constit.txt");
                        }
                        catch (IOException e) {
                            Throwables.propagate((Throwable)e);
                        }
                        return null;
                    }
                }, (Executor)this.exec));
            }
            Map exceptions = FutureIterables.awaitCompletion((Map)responses, (ListeningExecutorService)this.exec, (Long)30000L, (Logger)Logger.CONSOLE, (String)"get constitution");
            if (!exceptions.isEmpty()) {
                throw (Exception)exceptions.values().iterator().next();
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    private void uploadByteSource(String container, String name, String contentDisposition, ByteSource byteSource) throws IOException {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        blobStore.putBlob(container, blobStore.blobBuilder(name).payload((Payload)new ByteSourcePayload(byteSource)).contentType("text/plain").contentMD5(byteSource.hash(Hashing.md5())).contentLength(byteSource.size()).contentDisposition(contentDisposition).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetIfModifiedSince() throws InterruptedException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            Date before = new Date(System.currentTimeMillis() - 1000L);
            this.addObjectAndValidateContent(container, name);
            this.addObjectAndValidateContent(container, name);
            Date after = new Date(System.currentTimeMillis() + 1000L);
            ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifModifiedSince((Date)before));
            this.validateContent(container, name);
            try {
                ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifModifiedSince((Date)after));
                this.validateContent(container, name);
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)304);
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testCreateBlobWithExpiry() throws InterruptedException {
        String container = this.getContainerName();
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        try {
            String blobName = "hello";
            Date expires = new Date(System.currentTimeMillis() / 1000L * 1000L + 60000L);
            blobStore.putBlob(container, blobStore.blobBuilder("hello").payload(TEST_STRING).expires(expires).build());
            this.assertConsistencyAwareBlobExpiryMetadata(container, "hello", expires);
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putBlobWithMd5(byte[] payload, HashCode contentMD5) throws InterruptedException, IOException {
        String container = this.getContainerName();
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        try {
            String blobName = "putBlobWithMd5-" + new Random().nextLong();
            Blob blob = blobStore.blobBuilder(blobName).payload(payload).contentMD5(contentMD5).build();
            blobStore.putBlob(container, blob);
        }
        finally {
            this.returnContainer(container);
        }
    }

    protected int getIncorrectContentMD5StatusCode() {
        return 400;
    }

    @Test(groups={"integration", "live"})
    public void testPutCorrectContentMD5() throws InterruptedException, IOException {
        byte[] payload = BaseBlobIntegrationTest.createTestInput(1024).read();
        HashCode contentMD5 = Hashing.md5().hashBytes(payload);
        this.putBlobWithMd5(payload, contentMD5);
    }

    @Test(groups={"integration", "live"})
    public void testPutIncorrectContentMD5() throws InterruptedException, IOException {
        block2: {
            byte[] payload = BaseBlobIntegrationTest.createTestInput(1024).read();
            HashCode contentMD5 = Hashing.md5().hashBytes(new byte[0]);
            try {
                this.putBlobWithMd5(payload, contentMD5);
                Assert.fail();
            }
            catch (HttpResponseException hre) {
                if (hre.getResponse().getStatusCode() == this.getIncorrectContentMD5StatusCode()) break block2;
                throw hre;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetIfUnmodifiedSince() throws InterruptedException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            Date before = new Date(System.currentTimeMillis() - 5000L);
            this.addObjectAndValidateContent(container, name);
            Date after = new Date(System.currentTimeMillis() + 5000L);
            Uninterruptibles.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifUnmodifiedSince((Date)after));
            this.validateContent(container, name);
            try {
                ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifUnmodifiedSince((Date)before));
                this.validateContent(container, name);
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)412);
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetIfMatch() throws InterruptedException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            String goodETag = this.addObjectAndValidateContent(container, name);
            ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifETagMatches((String)goodETag));
            this.validateContent(container, name);
            try {
                ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifETagMatches((String)"powerfrisbee"));
                this.validateContent(container, name);
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)412);
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetIfNoneMatch() throws InterruptedException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            String goodETag = this.addObjectAndValidateContent(container, name);
            ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifETagDoesntMatch((String)"powerfrisbee"));
            this.validateContent(container, name);
            try {
                ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifETagDoesntMatch((String)goodETag));
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)304);
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetRange() throws InterruptedException, IOException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            this.addObjectAndValidateContent(container, name);
            Blob blob1 = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.range((long)0L, (long)5L));
            this.validateMetadata(blob1.getMetadata(), container, name);
            Assert.assertEquals((String)BaseBlobIntegrationTest.getContentAsStringOrNullAndClose(blob1), (String)TEST_STRING.substring(0, 6));
            Blob blob2 = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.range((long)6L, (long)TEST_STRING.length()));
            this.validateMetadata(blob2.getMetadata(), container, name);
            Assert.assertEquals((String)BaseBlobIntegrationTest.getContentAsStringOrNullAndClose(blob2), (String)TEST_STRING.substring(6, TEST_STRING.length()));
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetTwoRanges() throws InterruptedException, IOException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            this.addObjectAndValidateContent(container, name);
            Blob blob = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.range((long)0L, (long)5L).range(6L, (long)TEST_STRING.length()));
            this.validateMetadata(blob.getMetadata(), container, name);
            Assert.assertEquals((String)BaseBlobIntegrationTest.getContentAsStringOrNullAndClose(blob), (String)TEST_STRING);
        }
        finally {
            this.returnContainer(container);
        }
    }

    private String addObjectAndValidateContent(String sourcecontainer, String sourceKey) throws InterruptedException {
        String eTag = this.addBlobToContainer(sourcecontainer, sourceKey);
        this.validateContent(sourcecontainer, sourceKey);
        return eTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void deleteObjectNotFound() throws InterruptedException {
        String container = this.getContainerName();
        String name = "test";
        try {
            ((BlobStoreContext)this.view).getBlobStore().removeBlob(container, name);
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void blobNotFound() throws InterruptedException {
        String container = this.getContainerName();
        String name = "test";
        try {
            assert (!((BlobStoreContext)this.view).getBlobStore().blobExists(container, name));
        }
        finally {
            this.returnContainer(container);
        }
    }

    @DataProvider(name="delete")
    public Object[][] createData() {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            return new Object[][]{{"normal"}, {"sp ace"}};
        }
        return new Object[][]{{"normal"}, {"sp ace"}, {"qu?stion"}, {"unic\u20aade"}, {"path/foo"}, {"colon:"}, {"asteri*k"}, {"quote\""}, {"{great<r}"}, {"lesst>en"}, {"p|pe"}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"}, dataProvider="delete")
    public void deleteObject(String name) throws InterruptedException {
        String container = this.getContainerName();
        try {
            this.addBlobToContainer(container, name, name, "text/plain");
            ((BlobStoreContext)this.view).getBlobStore().removeBlob(container, name);
            this.assertContainerEmptyDeleting(container, name);
        }
        finally {
            this.returnContainer(container);
        }
    }

    private void assertContainerEmptyDeleting(String container, String name) {
        Iterable listing = Iterables.filter((Iterable)((BlobStoreContext)this.view).getBlobStore().list(container), (Predicate)new Predicate<StorageMetadata>(){

            public boolean apply(StorageMetadata input) {
                return input.getType() == StorageType.BLOB;
            }
        });
        Assert.assertEquals((int)Iterables.size((Iterable)listing), (int)0, (String)String.format("deleting %s, we still have %s blobs left in container %s, using encoding %s", name, Iterables.size((Iterable)listing), container, LOCAL_ENCODING));
    }

    @Test(groups={"integration", "live"})
    public void deleteObjectNoContainer() {
        try {
            ((BlobStoreContext)this.view).getBlobStore().removeBlob("donb", "test");
        }
        catch (HttpResponseException e) {
            Assert.assertEquals((int)e.getResponse().getStatusCode(), (int)404);
        }
        catch (ContainerNotFoundException containerNotFoundException) {
            // empty catch block
        }
    }

    @DataProvider(name="putTests")
    public Object[][] createData1() throws IOException {
        File file = new File("pom.xml");
        String realObject = Files.toString((File)file, (Charset)Charsets.UTF_8);
        return new Object[][]{{"file", "text/xml", file, realObject}, {"string", "text/xml", realObject, realObject}, {"bytes", "application/octet-stream", realObject.getBytes(), realObject}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"}, dataProvider="putTests")
    public void testPutObject(String name, String type, Object content, Object realObject) throws InterruptedException, IOException {
        BlobBuilder.PayloadBlobBuilder blobBuilder = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(Payloads.newPayload((Object)content)).contentType(type);
        this.addContentMetadata(blobBuilder);
        Blob blob = blobBuilder.build();
        String container = this.getContainerName();
        try {
            Assert.assertNotNull((Object)((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob));
            blob = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, blob.getMetadata().getName());
            this.validateMetadata(blob.getMetadata(), container, name);
            this.checkContentMetadata(blob);
            String returnedString = BaseBlobIntegrationTest.getContentAsStringOrNullAndClose(blob);
            Assert.assertEquals((Object)returnedString, (Object)realObject);
            PageSet set = ((BlobStoreContext)this.view).getBlobStore().list(container);
            assert (set.size() == 1) : set;
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutObjectStream() throws InterruptedException, IOException, ExecutionException {
        BlobBuilder.PayloadBlobBuilder blobBuilder = ((BlobStoreContext)this.view).getBlobStore().blobBuilder("streaming").payload((Payload)new ByteSourcePayload(ByteSource.wrap((byte[])"foo".getBytes())));
        this.addContentMetadata(blobBuilder);
        Blob blob = blobBuilder.build();
        String container = this.getContainerName();
        try {
            Assert.assertNotNull((Object)((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob));
            blob = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, blob.getMetadata().getName());
            String returnedString = BaseBlobIntegrationTest.getContentAsStringOrNullAndClose(blob);
            Assert.assertEquals((String)returnedString, (String)"foo");
            this.validateMetadata(blob.getMetadata(), container, blob.getMetadata().getName());
            this.checkContentMetadata(blob);
            PageSet set = ((BlobStoreContext)this.view).getBlobStore().list(container);
            assert (set.size() == 1) : set;
        }
        finally {
            this.returnContainer(container);
        }
    }

    protected void checkContentMetadata(Blob blob) {
        this.checkContentType(blob, "text/csv");
        this.checkContentDisposition(blob, "attachment; filename=photo.jpg");
        this.checkContentEncoding(blob, "gzip");
        this.checkContentLanguage(blob, "en");
    }

    private void addContentMetadata(BlobBuilder.PayloadBlobBuilder blobBuilder) {
        blobBuilder.contentType("text/csv");
        blobBuilder.contentDisposition("attachment; filename=photo.jpg");
        blobBuilder.contentEncoding("gzip");
        blobBuilder.contentLanguage("en");
    }

    protected void checkContentType(Blob blob, String contentType) {
        assert (blob.getPayload().getContentMetadata().getContentType().startsWith(contentType)) : blob.getPayload().getContentMetadata().getContentType();
        assert (blob.getMetadata().getContentMetadata().getContentType().startsWith(contentType)) : blob.getMetadata().getContentMetadata().getContentType();
    }

    protected void checkContentDisposition(Blob blob, String contentDisposition) {
        assert (blob.getPayload().getContentMetadata().getContentDisposition().startsWith(contentDisposition)) : blob.getPayload().getContentMetadata().getContentDisposition();
        assert (blob.getMetadata().getContentMetadata().getContentDisposition().startsWith(contentDisposition)) : blob.getMetadata().getContentMetadata().getContentDisposition();
    }

    protected void checkContentEncoding(Blob blob, String contentEncoding) {
        assert (blob.getPayload().getContentMetadata().getContentEncoding().indexOf(contentEncoding) != -1) : blob.getPayload().getContentMetadata().getContentEncoding();
        assert (blob.getMetadata().getContentMetadata().getContentEncoding().indexOf(contentEncoding) != -1) : blob.getMetadata().getContentMetadata().getContentEncoding();
    }

    protected void checkContentLanguage(Blob blob, String contentLanguage) {
        assert (blob.getPayload().getContentMetadata().getContentLanguage().startsWith(contentLanguage)) : blob.getPayload().getContentMetadata().getContentLanguage();
        assert (blob.getMetadata().getContentMetadata().getContentLanguage().startsWith(contentLanguage)) : blob.getMetadata().getContentMetadata().getContentLanguage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testMetadata() throws InterruptedException, IOException {
        String name = "hello";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).userMetadata((Map)ImmutableMap.of((Object)"Adrian", (Object)"powderpuff")).payload(TEST_STRING).contentType("text/plain").contentMD5(Hashing.md5().hashString((CharSequence)TEST_STRING, Charsets.UTF_8).asBytes()).build();
        String container = this.getContainerName();
        try {
            Assert.assertNull((Object)((BlobStoreContext)this.view).getBlobStore().blobMetadata(container, "powderpuff"));
            this.addBlobToContainer(container, blob);
            Blob newObject = this.validateContent(container, name);
            MutableBlobMetadata metadata = newObject.getMetadata();
            this.validateMetadata((BlobMetadata)metadata);
            this.validateMetadata(metadata, container, name);
            this.validateMetadata(((BlobStoreContext)this.view).getBlobStore().blobMetadata(container, name));
            blob.getMetadata().getUserMetadata().put("Adrian", "wonderpuff");
            blob.getMetadata().getUserMetadata().put("Adrian", "powderpuff");
            this.addBlobToContainer(container, blob);
            this.validateMetadata(((BlobStoreContext)this.view).getBlobStore().blobMetadata(container, name));
        }
        finally {
            this.returnContainer(container);
        }
    }

    protected void validateMetadata(BlobMetadata metadata) throws IOException {
        assert (metadata.getContentMetadata().getContentType().startsWith("text/plain")) : metadata.getContentMetadata().getContentType();
        Assert.assertEquals((Object)metadata.getContentMetadata().getContentLength(), (Object)TEST_STRING.length());
        Assert.assertEquals((String)((String)metadata.getUserMetadata().get("adrian")), (String)"powderpuff");
        this.checkMD5(metadata);
    }

    protected void checkMD5(BlobMetadata metadata) throws IOException {
        Assert.assertEquals((byte[])metadata.getContentMetadata().getContentMD5(), (byte[])Hashing.md5().hashString((CharSequence)TEST_STRING, Charsets.UTF_8).asBytes());
    }

    private static ByteSource createTestInput(int length) {
        Random random = new Random();
        byte[] buffer = new byte[random.nextInt(length)];
        random.nextBytes(buffer);
        return ByteSource.wrap((byte[])buffer);
    }

    static {
        try {
            crypto = new JCECrypto();
        }
        catch (NoSuchAlgorithmException e) {
            Throwables.propagate((Throwable)e);
        }
        catch (CertificateException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

