(ns repl-utils.core
  (:require [org.timmc.handy.repl :as repl]
            [clojure.tools.logging :refer (infof)]))

(defn show [& args]
  (let [x (first args)
        opts (second args)
        opts (if opts
               opts
               {:inherit true})]
    (repl/show x opts)))

(in-ns 'clojure.core)

(defn show [& args]
  (apply repl-utils.core/show args))

(defmacro inspect [expr]
  `(let [in# (quote ~expr)
         resp# (do ~expr)]
     (clojure.tools.logging/infof "%s is %s" in# resp#)
     (printf "%s is %s\n" in# resp#)
     resp#))
