(ns leiningen.new.appkit
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "appkit"))

(defn appkit
  "Generate a new project for use on App Engine."
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' appkit project.")
    (->files data
             ["README.md" (render "README.md" data)]
             ["project.clj" (render "project.clj" data)]
             [".gitignore" (render "gitignore" data)]
             ["src/{{sanitized}}/api.clj" (render "api.clj" data)]
             ["src/{{sanitized}}/design.clj" (render "design.clj" data)]
             ["src/{{sanitized}}/ui.cljs" (render "ui.cljs" data)]
             ["resources/public/index.html" (render "index.html" data)]
             ["war-resources/WEB-INF/appengine-web.xml" (render "appengine-web.xml" data)]
             ["war-resources/WEB-INF/logging.properties" (render "logging.properties" data)])))
