(ns {{name}}.api
    (:require [ring.util.response :refer [response]]
              [ring.middleware.stacktrace :refer [wrap-stacktrace-log]]
              [compojure.core :refer [defroutes GET POST]]
              [compojure.route :as route]
              [appengine.ring.middleware :refer [wrap-defaults]]
              [appengine.datastore :as datastore]
              [appengine.datastore.query :as query]))

(defroutes routes
  (GET "/error" {}
       (throw (Exception. "Throw this error on purpose.")))
  (route/not-found nil))

(def handler (-> routes
                 (wrap-defaults)
                 (wrap-stacktrace-log)))
