(ns leiningen.new.apijr
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "apijr"))

(defn apijr
  "Template for contructing clojurescript projects
   backed by clojures apis."
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh clojurescript and compojure api project!")
    (->files data
             ["src/clj/{{sanitized}}/core.clj" (render "core.clj" data)]
             ["project.clj" (render "project.clj" data)]
             ["src/cljs/{{sanitized}}/core.cljs" (render "core.cljs" data)]
             [".gitignore" (render ".gitignore" data)])))
