(ns core
    "AWS Lambda function example"
    (:gen-class :implements [com.amazonaws.services.lambda.runtime.RequestStreamHandler])
    (:require [cheshire.core :as json]
              [clojure.java.io :as io]
              [clojure.string :as str])
    (:import (com.amazonaws.services.lambda.runtime Context)))

(defn- request
  [is]
  (json/parse-stream (io/reader is)))

(defn- plain-response
  [os content]
  (let [w (io/writer os)]
    (.write w content)
    (.flush w)))

(defn- json-response
  [os content]
  (plain-response os (json/generate-string content)))

(defn -handleRequest
  [this is os context]
  (let
    [data (request is)
     message {:response (str (get data "message") "\n" "FUNCTION RESPONSE")}]
    (json-response os message)))
