(ns weareinstrumentv3.hooks.role
  (require [caribou.model :as model]
           [weareinstrumentv3.permissions :as permissions]))

(defn create-perms
  [env]
  (let [role-id (-> env :content :id)
        title (-> env :content :title)
        models (model/gather :model)
        mask (if (= title "admin")
               (permissions/mask :read :write :create :delete)
               0)]
    (doseq [model models]
      (model/create :permission {:model_id (:id model)
                                 :role_id role-id
                                 :mask mask}))
    env))

(defn destroy-perms
  [env]
  (let [role-id (-> env :content :id)
        perms (model/gather :permission {:where {:role_id role-id}})]
    (doseq [perm perms]
      (model/destroy :permission (:id perm)))
    env))

(model/add-hook :role :after_create :reinitialize create-perms)

(model/add-hook :role :before_destroy :reinitialize destroy-perms)
