(ns weareinstrumentv3.hooks.model
  (require [caribou.model :as model]
           [weareinstrumentv3.permissions :as permissions]))


;; a model hook recieves a map as its sole arg, that map contains keys that
;; are partially specific to its lifecycle position
;; :content - the thing hooked
;; :model - the relevant model
;; :values - arguments to the function spawning hook
;; :op - the operation spawning the hook (mainly used for the save hooks)
;; :opts - optional opts arg to model/create
;; :spec - for create hooks, describes how one would update this row
;; :original - for update hooks, the object before the operation in question

;; creation hooks in order called
:before_save
:before_create
:after_create
:after_save

;; update hooks in order called
:before_save
:before_update
:after_update
:after_save

;; destroy hooks in order called
:before_destroy
:after_destroy

(defn create-perms
  [env]
  (let [model-id (-> env :content :id)
        roles (model/gather :role)
        root-mask (permissions/mask :read :write :create :delete)]
    (doseq [role roles]
      (model/create :permission {:model_id model-id
                                 :role_id (:id role)
                                 :mask (if (= (:title role) "admin")
                                         root-mask
                                         0)}))
    env))

(defn destroy-perms
  [env]
  (let [model-id (-> env :content :id)
        perms (model/gather :permission {:where {:model_id model-id}})]
    (doseq [perm perms]
      (model/destroy :permission (:id perm)))
    env))

(model/add-hook :model :after_create :reinitialize create-perms)

(model/add-hook :model :before_destroy :reinitialize destroy-perms)
