(defproject antistock/zooconf "0.1.26"
  :description "Antistock configuration"
  :url "https://bitbucket.org/antistock/zooconf"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[antistock/core "0.3.0"]
                 [antistock/config "0.1.24"]
                 [antistock/curator "0.1.2"]
                 [ch.qos.logback/logback-classic "1.1.7"]
                 [commandline-clj "0.2.1"]
                 [environ "1.0.3"]
                 [javax.mail/mail "1.4.7"]
                 [org.clojure/clojure "1.8.0"]
                 [org.codehaus.janino/janino "2.7.8"]
                 [prismatic/schema "1.1.1"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]}
  :main ^{:skip-aot true} antistock.zooconf.main
  :plugins [[lein-environ "1.0.3"]]
  :profiles {:dev {:plugins [[jonase/eastwood "0.2.3"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]}
             :uberjar {:aot :all :main antistock.zooconf.main}}
  :uberjar-name "antistock-zooconf.jar")
