-- Revert remove-wikipedia-projects

BEGIN;

CREATE TABLE wikipedia.projects (
  id SERIAL PRIMARY KEY,
  name CITEXT UNIQUE NOT NULL,
  url TEXT UNIQUE NOT NULL,
  abbrev CITEXT UNIQUE,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX wikipedia_projects_name_fulltext_index ON wikipedia.projects USING gin(to_tsvector('english', name));

CREATE TRIGGER wikipedia_projects_created_at_trigger
  BEFORE INSERT ON wikipedia.projects FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER wikipedia_projects_updated_at_trigger
  BEFORE UPDATE ON wikipedia.projects FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

DROP TABLE wikipedia.page_views CASCADE;

CREATE TABLE wikipedia.page_views (
  id SERIAL PRIMARY KEY,
  project_id INTEGER NOT NULL REFERENCES wikipedia.projects(id) ON DELETE CASCADE,
  page_id INTEGER NOT NULL REFERENCES wikipedia.pages(id) ON DELETE CASCADE,
  language_id INTEGER NOT NULL REFERENCES languages(id) ON DELETE CASCADE,
  count INTEGER NOT NULL,
  size INTEGER NOT NULL,
  views_at TIMESTAMP WITH TIME ZONE NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX wikipedia_page_views_page_id_index ON wikipedia.page_views (page_id);
CREATE INDEX wikipedia_page_views_language_id_index ON wikipedia.page_views (language_id);
CREATE INDEX wikipedia_page_views_views_at_index ON wikipedia.page_views (views_at);
CREATE UNIQUE INDEX wikipedia_page_views_project_id_page_id_views_at_index ON wikipedia.page_views (project_id, page_id, language_id, views_at);

CREATE TRIGGER wikipedia_page_views_created_at_trigger
  BEFORE INSERT ON wikipedia.page_views FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER wikipedia_page_views_updated_at_trigger
  BEFORE UPDATE ON wikipedia.page_views FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
