-- Deploy create-wikipedia-page-edits-table

BEGIN;

CREATE TABLE wikipedia.page_edits (
  id SERIAL PRIMARY KEY,
  page_id INTEGER NOT NULL REFERENCES wikipedia.pages(id) ON DELETE CASCADE,
  author TEXT NOT NULL,
  size INTEGER NOT NULL,
  edited_at TIMESTAMP WITH TIME ZONE NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX wikipedia_page_edits_page_id_index ON wikipedia.page_edits (page_id);
CREATE INDEX wikipedia_page_edits_edited_at_index ON wikipedia.page_edits (edited_at);

CREATE TRIGGER wikipedia_page_edits_created_at_trigger
  BEFORE INSERT ON wikipedia.page_edits FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER wikipedia_page_edits_updated_at_trigger
  BEFORE UPDATE ON wikipedia.page_edits FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
