-- Deploy create-prices-table
-- requires: create-prices-table

BEGIN;

CREATE TABLE prices (
  id serial PRIMARY KEY,
  quote_id integer REFERENCES quotes(id) ON DELETE CASCADE,
  date date NOT NULL,
  open numeric NOT NULL,
  close numeric NOT NULL,
  high numeric NOT NULL,
  low numeric NOT NULL,
  volume numeric NOT NULL,
  adj_close numeric NOT NULL,
  daily_return numeric,
  created_at timestamp with time zone NOT NULL DEFAULT now(),
  updated_at timestamp with time zone NOT NULL DEFAULT now()
);

CREATE UNIQUE INDEX prices_quote_id_date_idx ON prices (quote_id, date);
CREATE INDEX prices_quote_id_idx ON prices (quote_id);
CREATE INDEX prices_date_idx ON prices (date);
CREATE INDEX prices_daily_return_idx ON prices (daily_return);

CREATE TRIGGER prices_created_at_trigger
  BEFORE INSERT ON prices FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER prices_updated_at_trigger
  BEFORE UPDATE ON prices FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
